/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;
import org.kie.kogito.index.mongodb.model.ProcessInstanceEntity;
import org.kie.kogito.index.mongodb.model.ProcessInstanceEntityMapper;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;

class ProcessInstanceEntityMapperTest {
    ProcessInstanceEntityMapper processInstanceEntityMapper = new ProcessInstanceEntityMapper();
    static ProcessInstance processInstance;
    static ProcessInstanceEntity processInstanceEntity;

    ProcessInstanceEntityMapperTest() {
    }

    @BeforeAll
    static void setup() {
        String nodeInstanceId = "testNodeInstanceId";
        String nodeInstanceName = "testNodeInstanceName";
        String nodeInstanceNodeId = "testNodeInstanceNodeId";
        String nodeInstanceType = "testNodeInstanceType";
        String nodeInstanceDefinitionId = "testNodeInstanceDefinitionId";
        String processInstanceErrorMessage = "testProcessInstanceErrorMessage";
        String processInstanceErrorNodeDefinitionId = "testProcessInstanceErrorNodeDefinitionId";
        String milestoneId = "testMilestone";
        String milestoneName = "testMilestoneName";
        String milestoneStatus = "testMilestoneStatus";
        String testId = "testId";
        String processId = "testProcessId";
        Set<String> roles = Set.of("testRoles");
        ObjectNode variables = ModelUtils.MAPPER.createObjectNode();
        variables.put("test", "testValue");
        String endpoint = "testEndpoint";
        Integer state = 2;
        ZonedDateTime time = ZonedDateTime.now();
        String rootProcessId = "testRootProcessId";
        String rootProcessInstanceId = "testRootProcessInstanceId";
        String parentProcessInstanceId = "testParentProcessInstanceId";
        String processName = "testProcessName";
        Set<String> addons = Set.of("testAddons");
        String businessKey = "testBusinessKey";
        String createdBy = "testCreatedBy";
        String updatedBy = "testUpdatedBy";
        NodeInstance nodeInstance = new NodeInstance();
        nodeInstance.setId(nodeInstanceId);
        nodeInstance.setDefinitionId(nodeInstanceDefinitionId);
        nodeInstance.setExit(time);
        nodeInstance.setEnter(time);
        nodeInstance.setType(nodeInstanceType);
        nodeInstance.setNodeId(nodeInstanceNodeId);
        nodeInstance.setName(nodeInstanceName);
        ProcessInstanceError processInstanceError = new ProcessInstanceError();
        processInstanceError.setMessage(processInstanceErrorMessage);
        processInstanceError.setNodeDefinitionId(processInstanceErrorNodeDefinitionId);
        Milestone milestone = new Milestone();
        milestone.setId(milestoneId);
        milestone.setName(milestoneName);
        milestone.setStatus(milestoneStatus);
        processInstance = new ProcessInstance();
        processInstance.setId(testId);
        processInstance.setProcessId(processId);
        processInstance.setRoles(roles);
        processInstance.setVariables(variables);
        processInstance.setEndpoint(endpoint);
        processInstance.setNodes(List.of(nodeInstance));
        processInstance.setState(state);
        processInstance.setStart(time);
        processInstance.setEnd(time);
        processInstance.setRootProcessId(rootProcessId);
        processInstance.setRootProcessInstanceId(rootProcessInstanceId);
        processInstance.setParentProcessInstanceId(parentProcessInstanceId);
        processInstance.setProcessName(processName);
        processInstance.setError(processInstanceError);
        processInstance.setAddons(addons);
        processInstance.setLastUpdate(time);
        processInstance.setBusinessKey(businessKey);
        processInstance.setMilestones(List.of(milestone));
        processInstance.setCreatedBy(createdBy);
        processInstance.setUpdatedBy(updatedBy);
        ProcessInstanceEntity.NodeInstanceEntity nodeInstanceEntity = new ProcessInstanceEntity.NodeInstanceEntity();
        nodeInstanceEntity.setId(nodeInstanceId);
        nodeInstanceEntity.setDefinitionId(nodeInstanceDefinitionId);
        nodeInstanceEntity.setEnter(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        nodeInstanceEntity.setExit(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        nodeInstanceEntity.setName(nodeInstanceName);
        nodeInstanceEntity.setNodeId(nodeInstanceNodeId);
        nodeInstanceEntity.setType(nodeInstanceType);
        ProcessInstanceEntity.ProcessInstanceErrorEntity processInstanceErrorEntity = new ProcessInstanceEntity.ProcessInstanceErrorEntity();
        processInstanceErrorEntity.setMessage(processInstanceErrorMessage);
        processInstanceErrorEntity.setNodeDefinitionId(processInstanceErrorNodeDefinitionId);
        ProcessInstanceEntity.MilestoneEntity milestoneEntity = new ProcessInstanceEntity.MilestoneEntity();
        milestoneEntity.setId(milestoneId);
        milestoneEntity.setName(milestoneName);
        milestoneEntity.setStatus(milestoneStatus);
        processInstanceEntity = new ProcessInstanceEntity();
        processInstanceEntity.setId(testId);
        processInstanceEntity.setProcessId(processId);
        processInstanceEntity.setRoles(roles);
        processInstanceEntity.setVariables(ModelUtils.jsonNodeToDocument((JsonNode)variables));
        processInstanceEntity.setEndpoint(endpoint);
        processInstanceEntity.setNodes(List.of(nodeInstanceEntity));
        processInstanceEntity.setState(state);
        processInstanceEntity.setStart(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        processInstanceEntity.setEnd(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        processInstanceEntity.setRootProcessId(rootProcessId);
        processInstanceEntity.setRootProcessInstanceId(rootProcessInstanceId);
        processInstanceEntity.setParentProcessInstanceId(parentProcessInstanceId);
        processInstanceEntity.setProcessName(processName);
        processInstanceEntity.setError(processInstanceErrorEntity);
        processInstanceEntity.setAddons(addons);
        processInstanceEntity.setLastUpdate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        processInstanceEntity.setBusinessKey(businessKey);
        processInstanceEntity.setMilestones(List.of(milestoneEntity));
        processInstanceEntity.setCreatedBy(createdBy);
        processInstanceEntity.setUpdatedBy(updatedBy);
    }

    @Test
    void testGetEntityClass() {
        Assertions.assertEquals(ProcessInstanceEntity.class, (Object)this.processInstanceEntityMapper.getEntityClass());
    }

    @Test
    void testMapToEntity() {
        ProcessInstanceEntity result = this.processInstanceEntityMapper.mapToEntity(processInstance.getId(), processInstance);
        Assertions.assertEquals((Object)processInstanceEntity, (Object)result);
    }

    @Test
    void testMapToModel() {
        ProcessInstance result = this.processInstanceEntityMapper.mapToModel(processInstanceEntity);
        Assertions.assertEquals((Object)processInstance, (Object)result);
    }

    @Test
    void testConvertToMongoAttribute() {
        Assertions.assertEquals((Object)"_id", (Object)this.processInstanceEntityMapper.convertToMongoAttribute("id"));
        Assertions.assertEquals((Object)"nodes._id", (Object)this.processInstanceEntityMapper.convertToMongoAttribute("nodes.id"));
        Assertions.assertEquals((Object)"milestones._id", (Object)this.processInstanceEntityMapper.convertToMongoAttribute("milestones.id"));
        String testAttribute = "testAttribute";
        Assertions.assertEquals((Object)testAttribute, (Object)this.processInstanceEntityMapper.convertToMongoAttribute(testAttribute));
    }

    @Test
    void testConvertToModelAttribute() {
        Assertions.assertEquals((Object)"id", (Object)this.processInstanceEntityMapper.convertToModelAttribute("_id"));
        Assertions.assertEquals((Object)"id", (Object)this.processInstanceEntityMapper.convertToModelAttribute("nodes._id"));
        Assertions.assertEquals((Object)"id", (Object)this.processInstanceEntityMapper.convertToModelAttribute("milestones._id"));
        String testAttribute = "test.attribute.go";
        Assertions.assertEquals((Object)"go", (Object)this.processInstanceEntityMapper.convertToModelAttribute(testAttribute));
    }
}

