/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntity;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntityMapper;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;

class UserTaskInstanceEntityMapperTest {
    UserTaskInstanceEntityMapper userTaskInstanceEntityMapper = new UserTaskInstanceEntityMapper();
    static UserTaskInstance userTaskInstance;
    static UserTaskInstanceEntity userTaskInstanceEntity;

    UserTaskInstanceEntityMapperTest() {
    }

    @BeforeAll
    static void setup() {
        String testId = "testId";
        String description = "testDescription";
        String name = "testName";
        String priority = "10";
        String processInstanceId = "testProcessInstanceId";
        String state = "testState";
        String actualOwner = "testActualOwner";
        Set<String> adminGroups = Set.of("testAdminGroups");
        Set<String> adminUsers = Set.of("testAdminUsers");
        ZonedDateTime time = ZonedDateTime.now();
        Set<String> excludedUsers = Set.of("testExcludedUsers");
        Set<String> potentialGroups = Set.of("testPotentialGroups");
        Set<String> potentialUsers = Set.of("testPotentialUsers");
        String referenceName = "testReferenceName";
        String processId = "testProcessId";
        String rootProcessId = "testRootProcessId";
        String rootProcessInstanceId = "testRootProcessInstanceId";
        String externalReferenceId = "testExternalReferenceId";
        ObjectNode object = ModelUtils.MAPPER.createObjectNode();
        object.put("test", "testValue");
        ObjectNode inputs = object;
        ObjectNode outputs = object;
        String commentId = "testCommentId";
        String comment_content = "testCommentContent";
        String comment_updatedBy = "testCommentUpdatedBy";
        Comment comment = Comment.builder().id(commentId).updatedAt(time).updatedBy(comment_updatedBy).content(comment_content).build();
        UserTaskInstanceEntity.CommentEntity commentEntity = new UserTaskInstanceEntity.CommentEntity();
        commentEntity.setId(commentId);
        commentEntity.setContent(comment_content);
        commentEntity.setUpdatedAt(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        commentEntity.setUpdatedBy(comment_updatedBy);
        String attachmentId = "testAttachmentId";
        String attachment_name = "testCommentName";
        String attachment_content = "testCommentContent";
        String attachment_updatedBy = "testCommentUpdatedBy";
        Attachment attachment = Attachment.builder().id(attachmentId).updatedAt(time).updatedBy(attachment_updatedBy).content(attachment_content).name(attachment_name).build();
        UserTaskInstanceEntity.AttachmentEntity attachmentEntity = new UserTaskInstanceEntity.AttachmentEntity();
        attachmentEntity.setId(commentId);
        attachmentEntity.setContent(comment_content);
        attachmentEntity.setUpdatedAt(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        attachmentEntity.setUpdatedBy(comment_updatedBy);
        userTaskInstance = new UserTaskInstance();
        userTaskInstance.setId(testId);
        userTaskInstance.setDescription(description);
        userTaskInstance.setName(name);
        userTaskInstance.setPriority(priority);
        userTaskInstance.setProcessInstanceId(processInstanceId);
        userTaskInstance.setState(state);
        userTaskInstance.setActualOwner(actualOwner);
        userTaskInstance.setAdminGroups(adminGroups);
        userTaskInstance.setAdminUsers(adminUsers);
        userTaskInstance.setCompleted(time);
        userTaskInstance.setStarted(time);
        userTaskInstance.setExcludedUsers(excludedUsers);
        userTaskInstance.setPotentialGroups(potentialGroups);
        userTaskInstance.setPotentialUsers(potentialUsers);
        userTaskInstance.setReferenceName(referenceName);
        userTaskInstance.setLastUpdate(time);
        userTaskInstance.setProcessId(processId);
        userTaskInstance.setRootProcessId(rootProcessId);
        userTaskInstance.setRootProcessInstanceId(rootProcessInstanceId);
        userTaskInstance.setInputs(inputs);
        userTaskInstance.setOutputs(outputs);
        userTaskInstance.setComments(List.of(comment));
        userTaskInstance.setAttachments(List.of(attachment));
        userTaskInstance.setExternalReferenceId(externalReferenceId);
        userTaskInstance.setSlaDueDate(time);
        userTaskInstanceEntity = new UserTaskInstanceEntity();
        userTaskInstanceEntity.setId(testId);
        userTaskInstanceEntity.setDescription(description);
        userTaskInstanceEntity.setName(name);
        userTaskInstanceEntity.setPriority(priority);
        userTaskInstanceEntity.setProcessInstanceId(processInstanceId);
        userTaskInstanceEntity.setState(state);
        userTaskInstanceEntity.setActualOwner(actualOwner);
        userTaskInstanceEntity.setAdminGroups(adminGroups);
        userTaskInstanceEntity.setAdminUsers(adminUsers);
        userTaskInstanceEntity.setCompleted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        userTaskInstanceEntity.setStarted(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        userTaskInstanceEntity.setExcludedUsers(excludedUsers);
        userTaskInstanceEntity.setPotentialGroups(potentialGroups);
        userTaskInstanceEntity.setPotentialUsers(potentialUsers);
        userTaskInstanceEntity.setReferenceName(referenceName);
        userTaskInstanceEntity.setLastUpdate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
        userTaskInstanceEntity.setProcessId(processId);
        userTaskInstanceEntity.setRootProcessId(rootProcessId);
        userTaskInstanceEntity.setRootProcessInstanceId(rootProcessInstanceId);
        userTaskInstanceEntity.setInputs(ModelUtils.jsonNodeToDocument((JsonNode)inputs));
        userTaskInstanceEntity.setOutputs(ModelUtils.jsonNodeToDocument((JsonNode)outputs));
        userTaskInstanceEntity.setComments(List.of(commentEntity));
        userTaskInstanceEntity.setAttachments(List.of(attachmentEntity));
        userTaskInstanceEntity.setExternalReferenceId(externalReferenceId);
        userTaskInstanceEntity.setSlaDueDate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
    }

    @Test
    void testGetEntityClass() {
        Assertions.assertEquals(UserTaskInstanceEntity.class, (Object)this.userTaskInstanceEntityMapper.getEntityClass());
    }

    @Test
    void testMapToEntity() {
        UserTaskInstanceEntity result = this.userTaskInstanceEntityMapper.mapToEntity(userTaskInstance.getId(), userTaskInstance);
        Assertions.assertEquals((Object)userTaskInstanceEntity, (Object)result);
    }

    @Test
    void testMapToModel() {
        UserTaskInstance result = this.userTaskInstanceEntityMapper.mapToModel(userTaskInstanceEntity);
        Assertions.assertEquals((Object)userTaskInstance, (Object)result);
    }

    @Test
    void testConvertToMongoAttribute() {
        Assertions.assertEquals((Object)"_id", (Object)this.userTaskInstanceEntityMapper.convertToMongoAttribute("id"));
        Assertions.assertEquals((Object)"comments._id", (Object)this.userTaskInstanceEntityMapper.convertToMongoAttribute("comments.id"));
        Assertions.assertEquals((Object)"attachments._id", (Object)this.userTaskInstanceEntityMapper.convertToMongoAttribute("attachments.id"));
        String testAttribute = "testAttribute";
        Assertions.assertEquals((Object)testAttribute, (Object)this.userTaskInstanceEntityMapper.convertToMongoAttribute(testAttribute));
    }

    @Test
    void testConvertToModelAttribute() {
        Assertions.assertEquals((Object)"id", (Object)this.userTaskInstanceEntityMapper.convertToModelAttribute("_id"));
        Assertions.assertEquals((Object)"id", (Object)this.userTaskInstanceEntityMapper.convertToModelAttribute("comments._id"));
        Assertions.assertEquals((Object)"id", (Object)this.userTaskInstanceEntityMapper.convertToModelAttribute("attachments._id"));
        String testAttribute = "test.attribute.go";
        Assertions.assertEquals((Object)"go", (Object)this.userTaskInstanceEntityMapper.convertToModelAttribute(testAttribute));
    }
}

