/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.query;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.bson.Document;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.mongodb.model.DomainEntityMapper;
import org.kie.kogito.index.test.QueryTestBase;
import org.kie.kogito.index.test.QueryTestUtils;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageFetcher;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class DomainQueryIT
extends QueryTestBase<String, ObjectNode> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, ObjectNode> storage;

    DomainQueryIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("travels_domain", Document.class), "org.acme.travels.travels.Travels", (MongoEntityMapper)new DomainEntityMapper());
    }

    public Storage<String, ObjectNode> getStorage() {
        return this.storage;
    }

    @Test
    void test() {
        String processInstanceId1 = UUID.randomUUID().toString();
        String processInstanceId2 = UUID.randomUUID().toString();
        ObjectNode node1 = TestUtils.createDomainData((String)processInstanceId1, (String)"John", (String)"Doe");
        ObjectNode node2 = TestUtils.createDomainData((String)processInstanceId2, (String)"Jane", (String)"Toe");
        this.storage.put((Object)processInstanceId1, (Object)node1);
        this.storage.put((Object)processInstanceId2, (Object)node2);
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.in((String)"traveller.firstName", Arrays.asList("John", "Jane"))), null, null, null, new String[]{processInstanceId1, processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.equalTo((String)"traveller.firstName", (Object)"John")), null, null, null, new String[]{processInstanceId1});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.greaterThan((String)"traveller.age", (Object)27)), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.greaterThanEqual((String)"traveller.age", (Object)27)), null, null, null, new String[]{processInstanceId1, processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.lessThan((String)"traveller.age", (Object)27)), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.lessThanEqual((String)"traveller.age", (Object)27)), null, null, null, new String[]{processInstanceId1, processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.between((String)"traveller.age", (Object)27, (Object)28)), null, null, null, new String[]{processInstanceId1, processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.isNull((String)"traveller.age")), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.notNull((String)"traveller.age")), null, null, null, new String[]{processInstanceId1, processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.contains((String)"_id", (Object)processInstanceId2)), null, null, null, new String[]{processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.containsAny((String)"_id", Arrays.asList(processInstanceId1, processInstanceId2))), null, null, null, new String[]{processInstanceId1, processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.containsAll((String)"_id", Arrays.asList(processInstanceId1, processInstanceId2))), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.like((String)"traveller.firstName", (String)"*hn")), null, null, null, new String[]{processInstanceId1});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.equalTo((String)"traveller.firstName", (Object)"John"), QueryFilterFactory.equalTo((String)"traveller.lastName", (Object)"Doe")))), null, null, null, new String[]{processInstanceId1});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Collections.singletonList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.equalTo((String)"traveller.firstName", (Object)"John"), QueryFilterFactory.equalTo((String)"traveller.firstName", (Object)"Jane")))), null, null, null, new String[]{processInstanceId1, processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNode(), (StorageFetcher)this.storage, Arrays.asList(QueryFilterFactory.equalTo((String)"traveller.firstName", (Object)"John"), QueryFilterFactory.equalTo((String)"traveller.lastName", (Object)"Toe")), null, null, null, new String[0]);
        this.queryAndAssert(QueryTestUtils.assertWithObjectNodeInOrder(), (StorageFetcher)this.storage, Arrays.asList(QueryFilterFactory.in((String)"traveller.firstName", Arrays.asList("Jane", "John")), QueryFilterFactory.in((String)"traveller.lastName", Arrays.asList("Doe", "Toe"))), Collections.singletonList(QueryFilterFactory.orderBy((String)"traveller.lastName", (SortDirection)SortDirection.ASC)), 1, 1, new String[]{processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNodeInOrder(), (StorageFetcher)this.storage, null, Collections.singletonList(QueryFilterFactory.orderBy((String)"traveller.firstName", (SortDirection)SortDirection.ASC)), null, null, new String[]{processInstanceId2, processInstanceId1});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNodeInOrder(), (StorageFetcher)this.storage, null, null, 1, 1, new String[]{processInstanceId2});
        this.queryAndAssert(QueryTestUtils.assertWithObjectNodeInOrder(), (StorageFetcher)this.storage, null, Arrays.asList(QueryFilterFactory.orderBy((String)"traveller.firstName", (SortDirection)SortDirection.DESC), QueryFilterFactory.orderBy((String)"traveller.lastName", (SortDirection)SortDirection.ASC)), 1, 1, new String[]{processInstanceId2});
    }
}

