/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.mongodb.model.JobEntity;
import org.kie.kogito.index.mongodb.model.JobEntityMapper;
import org.kie.kogito.index.mongodb.storage.StorageTestBase;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class JobStorageIT
extends StorageTestBase<String, Job> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, Job> storage;

    JobStorageIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("jobs", JobEntity.class), Job.class.getName(), (MongoEntityMapper)new JobEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void testCache() {
        String jobId = UUID.randomUUID().toString();
        String processInstanceId = UUID.randomUUID().toString();
        Job job1 = TestUtils.createJob((String)jobId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"EXPECTED", (long)0L);
        Job job2 = TestUtils.createJob((String)jobId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"SCHEDULED", (long)1000L);
        this.testStorage(this.storage, jobId, job1, job2);
    }
}

