/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessDefinitionKey;
import org.kie.kogito.index.mongodb.model.ProcessDefinitionEntity;
import org.kie.kogito.index.mongodb.model.ProcessDefinitionEntityMapper;
import org.kie.kogito.index.mongodb.storage.StorageTestBase;
import org.kie.kogito.index.storage.ModelProcessDefinitionStorage;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class ProcessDefinitionStorageIT
extends StorageTestBase<ProcessDefinitionKey, ProcessDefinition> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<ProcessDefinitionKey, ProcessDefinition> storage;

    ProcessDefinitionStorageIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new ModelProcessDefinitionStorage((Storage)new MongoStorage(this.mongoClientManager.getCollection("processdefinitions", ProcessDefinitionEntity.class), ProcessDefinition.class.getName(), (MongoEntityMapper)new ProcessDefinitionEntityMapper()));
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void testCache() {
        String processId = RandomStringUtils.randomAlphabetic((int)10);
        String version = "1.0";
        ProcessDefinition pdv1 = TestUtils.createProcessDefinition((String)processId, (String)version, Set.of("admin", "kogito"));
        ProcessDefinition pdv2 = TestUtils.createProcessDefinition((String)processId, (String)version, Set.of("kogito"));
        this.testStorage(this.storage, new ProcessDefinitionKey(processId, version), pdv1, pdv2);
    }
}

