/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntity;
import org.kie.kogito.index.mongodb.model.UserTaskInstanceEntityMapper;
import org.kie.kogito.index.mongodb.storage.StorageTestBase;
import org.kie.kogito.index.test.TestUtils;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class UserTaskInstanceStorageIT
extends StorageTestBase<String, UserTaskInstance> {
    @Inject
    MongoClientManager mongoClientManager;
    Storage<String, UserTaskInstance> storage;

    UserTaskInstanceStorageIT() {
    }

    @BeforeEach
    void setUp() {
        this.storage = new MongoStorage(this.mongoClientManager.getCollection("usertaskinstances", UserTaskInstanceEntity.class), UserTaskInstance.class.getName(), (MongoEntityMapper)new UserTaskInstanceEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.storage.clear();
    }

    @Test
    void testCache() {
        String taskId = UUID.randomUUID().toString();
        String processInstanceId = UUID.randomUUID().toString();
        UserTaskInstance userTaskInstance1 = TestUtils.createUserTaskInstance((String)taskId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"InProgress", (long)0L);
        UserTaskInstance userTaskInstance2 = TestUtils.createUserTaskInstance((String)taskId, (String)processInstanceId, (String)RandomStringUtils.randomAlphabetic((int)5), (String)UUID.randomUUID().toString(), (String)RandomStringUtils.randomAlphabetic((int)10), (String)"Completed", (long)1000L);
        this.testStorage(this.storage, taskId, userTaskInstance1, userTaskInstance2);
    }
}

