/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.oracle.storage;

import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Attribute;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.index.oracle.model.AbstractEntity;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.api.query.SortDirection;

public class OracleQuery<E extends AbstractEntity, T>
implements Query<T> {
    private PanacheRepositoryBase<E, String> repository;
    private Integer limit;
    private Integer offset;
    private List<AttributeFilter<?>> filters;
    private List<AttributeSort> sortBy;
    private Class<E> entityClass;
    private Function<E, T> mapper;

    public OracleQuery(PanacheRepositoryBase<E, String> repository, Function<E, T> mapper, Class<E> entityClass) {
        this.repository = repository;
        this.mapper = mapper;
        this.entityClass = entityClass;
    }

    public Query<T> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query<T> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Query<T> filter(List<AttributeFilter<?>> filters) {
        this.filters = filters;
        return this;
    }

    public Query<T> sort(List<AttributeSort> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public List<T> execute() {
        CriteriaBuilder builder = this.repository.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        if (this.filters != null && !this.filters.isEmpty()) {
            List<Predicate> predicates = this.getPredicates(builder, root);
            criteriaQuery.where(predicates.toArray(new Predicate[0]));
        }
        if (this.sortBy != null && !this.sortBy.isEmpty()) {
            List orderBy = this.sortBy.stream().map(f -> {
                Path attributePath = this.getAttributePath(root, f.getAttribute());
                return f.getSort() == SortDirection.ASC ? builder.asc((Expression)attributePath) : builder.desc((Expression)attributePath);
            }).collect(Collectors.toList());
            criteriaQuery.orderBy(orderBy);
        }
        TypedQuery query = this.repository.getEntityManager().createQuery(criteriaQuery);
        if (this.limit != null) {
            query.setMaxResults(this.limit.intValue());
        }
        if (this.offset != null) {
            query.setFirstResult(this.offset.intValue());
        }
        return query.getResultList().stream().map(this.mapper).collect(Collectors.toList());
    }

    protected List<Predicate> getPredicates(CriteriaBuilder builder, Root<E> root) {
        return this.filters.stream().map(this.filterPredicateFunction(root, builder)).collect(Collectors.toList());
    }

    private Function<AttributeFilter<?>, Predicate> filterPredicateFunction(Root<E> root, CriteriaBuilder builder) {
        return filter -> {
            String attribute = filter.getAttribute();
            Object value = filter.getValue();
            switch (filter.getCondition()) {
                case CONTAINS: {
                    return builder.isMember(value, (Expression)this.getAttributePath(root, attribute));
                }
                case CONTAINS_ALL: {
                    List<Predicate> predicatesAll = ((List)value).stream().map(o -> builder.isMember(o, (Expression)this.getAttributePath(root, attribute))).collect(Collectors.toList());
                    return builder.and(predicatesAll.toArray(new Predicate[0]));
                }
                case CONTAINS_ANY: {
                    List<Predicate> predicatesAny = ((List)value).stream().map(o -> builder.isMember(o, (Expression)this.getAttributePath(root, attribute))).collect(Collectors.toList());
                    return builder.or(predicatesAny.toArray(new Predicate[0]));
                }
                case IN: {
                    return this.getAttributePath(root, attribute).in((Collection)value);
                }
                case LIKE: {
                    return builder.like((Expression)this.getAttributePath(root, attribute), value.toString().replaceAll("\\*", "%"));
                }
                case EQUAL: {
                    return builder.equal((Expression)this.getAttributePath(root, attribute), value);
                }
                case IS_NULL: {
                    Path pathNull = this.getAttributePath(root, attribute);
                    return this.isPluralAttribute(attribute) ? builder.isEmpty((Expression)pathNull) : builder.isNull((Expression)pathNull);
                }
                case NOT_NULL: {
                    Path pathNotNull = this.getAttributePath(root, attribute);
                    return this.isPluralAttribute(attribute) ? builder.isNotEmpty((Expression)pathNotNull) : builder.isNotNull((Expression)pathNotNull);
                }
                case BETWEEN: {
                    List v = (List)value;
                    return builder.between((Expression)this.getAttributePath(root, attribute), (Comparable)v.get(0), (Comparable)v.get(1));
                }
                case GT: {
                    return builder.greaterThan((Expression)this.getAttributePath(root, attribute), (Comparable)value);
                }
                case GTE: {
                    return builder.greaterThanOrEqualTo((Expression)this.getAttributePath(root, attribute), (Comparable)value);
                }
                case LT: {
                    return builder.lessThan((Expression)this.getAttributePath(root, attribute), (Comparable)value);
                }
                case LTE: {
                    return builder.lessThanOrEqualTo((Expression)this.getAttributePath(root, attribute), (Comparable)value);
                }
                case OR: {
                    return builder.or(this.getRecursivePredicate((AttributeFilter<?>)filter, root, builder).toArray(new Predicate[0]));
                }
                case AND: {
                    return builder.and(this.getRecursivePredicate((AttributeFilter<?>)filter, root, builder).toArray(new Predicate[0]));
                }
                case NOT: {
                    return builder.not((Expression)this.filterPredicateFunction(root, builder).apply((AttributeFilter)value));
                }
            }
            return null;
        };
    }

    private Path getAttributePath(Root<E> root, String attribute) {
        String[] split = attribute.split("\\.");
        if (split.length == 1) {
            return root.get(attribute);
        }
        Join join = root.join(split[0]);
        for (int i = 1; i < split.length - 1; ++i) {
            join = join.join(split[i]);
        }
        return join.get(split[split.length - 1]);
    }

    private boolean isPluralAttribute(String attribute) {
        return this.repository.getEntityManager().getMetamodel().entity(this.entityClass).getDeclaredPluralAttributes().stream().map(Attribute::getName).anyMatch(pluralAttribute -> pluralAttribute.equals(attribute));
    }

    private List<Predicate> getRecursivePredicate(AttributeFilter<?> filter, Root<E> root, CriteriaBuilder builder) {
        return ((List)filter.getValue()).stream().map(this.filterPredicateFunction(root, builder)).collect(Collectors.toList());
    }
}

