/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.oracle.storage;

import io.quarkus.arc.properties.IfBuildProperty;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessDefinition;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.oracle.storage.JobEntityStorage;
import org.kie.kogito.index.oracle.storage.ProcessDefinitionEntityStorage;
import org.kie.kogito.index.oracle.storage.ProcessInstanceEntityStorage;
import org.kie.kogito.index.oracle.storage.UserTaskInstanceEntityStorage;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;

@Alternative
@Priority(value=1)
@ApplicationScoped
@IfBuildProperty(name="kogito.apps.persistence.type", stringValue="oracle")
public class OracleStorageService
implements StorageService {
    @Inject
    ProcessDefinitionEntityStorage definitionStorage;
    @Inject
    ProcessInstanceEntityStorage processStorage;
    @Inject
    JobEntityStorage jobStorage;
    @Inject
    UserTaskInstanceEntityStorage taskStorage;

    public Storage<String, String> getCache(String name) {
        throw new UnsupportedOperationException("Generic String cache not available in OracleSQL");
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        if (type == ProcessInstance.class) {
            return this.processStorage;
        }
        if (type == ProcessDefinition.class) {
            return this.definitionStorage;
        }
        if (type == Job.class) {
            return this.jobStorage;
        }
        if (type == UserTaskInstance.class) {
            return this.taskStorage;
        }
        throw new UnsupportedOperationException(String.format("Unknown class type: %s, cache not available", type.getCanonicalName()));
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        throw new UnsupportedOperationException("Generic custom type cache not available in OracleSQL");
    }
}

