/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql;

import java.util.Iterator;
import java.util.List;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicTypeReference;

public class ContainsSQLFunction
extends StandardSQLFunction {
    static final String CONTAINS_NAME = "contains";
    static final String CONTAINS_ALL_NAME = "containsAll";
    static final String CONTAINS_ANY_NAME = "containsAny";
    static final String CONTAINS_SEQ = "??";
    static final String CONTAINS_ALL_SEQ = "??&";
    static final String CONTAINS_ANY_SEQ = "??|";
    private final String operator;
    private static final BasicTypeReference<Boolean> RETURN_TYPE = new BasicTypeReference("boolean", Boolean.class, 16);

    ContainsSQLFunction(String name, String operator) {
        super(name, RETURN_TYPE);
        this.operator = operator;
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> args, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        int size = args.size();
        if (size < 2) {
            throw new IllegalArgumentException("Function " + this.getName() + " requires at least two arguments");
        }
        Iterator<? extends SqlAstNode> iter = args.iterator();
        iter.next().accept(translator);
        sqlAppender.append(' ');
        sqlAppender.append((CharSequence)this.operator);
        sqlAppender.append(' ');
        if (size == 2) {
            iter.next().accept(translator);
        } else {
            sqlAppender.append((CharSequence)"array[");
            do {
                iter.next().accept(translator);
                sqlAppender.append(iter.hasNext() ? (char)',' : ']');
            } while (iter.hasNext());
        }
    }
}

