/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.persistence.api.query.AttributeFilter;

public class PostgresqlJsonHelper {
    private PostgresqlJsonHelper() {
    }

    public static Predicate buildPredicate(AttributeFilter<?> filter, Root<?> root, CriteriaBuilder builder) {
        switch (filter.getCondition()) {
            case EQUAL: {
                boolean isString = filter.getValue() instanceof String;
                return builder.equal(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), isString), PostgresqlJsonHelper.buildObjectExpression(builder, filter.getValue(), isString));
            }
            case GT: {
                boolean isString = filter.getValue() instanceof String;
                return builder.greaterThan(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), isString), PostgresqlJsonHelper.buildObjectExpression(builder, filter.getValue(), isString));
            }
            case GTE: {
                boolean isString = filter.getValue() instanceof String;
                return builder.greaterThanOrEqualTo(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), isString), PostgresqlJsonHelper.buildObjectExpression(builder, filter.getValue(), isString));
            }
            case LT: {
                boolean isString = filter.getValue() instanceof String;
                return builder.lessThan(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), isString), PostgresqlJsonHelper.buildObjectExpression(builder, filter.getValue(), isString));
            }
            case LTE: {
                boolean isString = filter.getValue() instanceof String;
                return builder.lessThanOrEqualTo(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), isString), PostgresqlJsonHelper.buildObjectExpression(builder, filter.getValue(), isString));
            }
            case LIKE: {
                return builder.like(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), true), filter.getValue().toString().replaceAll("\\*", "%"));
            }
            case IS_NULL: {
                return builder.isNull(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), false));
            }
            case NOT_NULL: {
                return builder.isNotNull(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), false));
            }
            case BETWEEN: {
                List values = (List)filter.getValue();
                boolean isString = values.get(0) instanceof String;
                return builder.between(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), isString), PostgresqlJsonHelper.buildObjectExpression(builder, values.get(0), isString), PostgresqlJsonHelper.buildObjectExpression(builder, values.get(1), isString));
            }
            case IN: {
                List values = (List)filter.getValue();
                boolean isString = values.get(0) instanceof String;
                return PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), isString).in((Collection)values.stream().map(o -> PostgresqlJsonHelper.buildObjectExpression(builder, o, isString)).collect(Collectors.toList()));
            }
            case CONTAINS: {
                return builder.isTrue(builder.function("contains", Boolean.class, new Expression[]{PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), false), builder.literal(filter.getValue())}));
            }
            case CONTAINS_ANY: {
                return PostgresqlJsonHelper.containsPredicate(filter, root, builder, "containsAny");
            }
            case CONTAINS_ALL: {
                return PostgresqlJsonHelper.containsPredicate(filter, root, builder, "containsAll");
            }
        }
        throw new UnsupportedOperationException("Filter " + filter + " is not supported");
    }

    private static Predicate containsPredicate(AttributeFilter<?> filter, Root<?> root, CriteriaBuilder builder, String name) {
        return builder.isTrue(builder.function(name, Boolean.class, (Expression[])Stream.concat(Stream.of(PostgresqlJsonHelper.buildPathExpression(builder, root, filter.getAttribute(), false)), ((List)filter.getValue()).stream().map(o -> builder.literal(o))).toArray(Expression[]::new)));
    }

    private static Expression buildObjectExpression(CriteriaBuilder builder, Object value, boolean isString) {
        return isString ? builder.literal(value) : builder.function("to_jsonb", Object.class, new Expression[]{builder.literal(value)});
    }

    private static Expression buildObjectExpression(CriteriaBuilder builder, Object value) {
        return PostgresqlJsonHelper.buildObjectExpression(builder, value, value instanceof String);
    }

    private static Expression buildPathExpression(CriteriaBuilder builder, Root<?> root, String attributeName, boolean isStr) {
        int startIndex;
        String[] attributes = attributeName.split("\\.");
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (attributes.length == 1) {
            return root.get(attributeName);
        }
        try {
            Join join = root.join(attributes[0]);
            arguments.add(join.get(attributes[1]));
            startIndex = 2;
        }
        catch (PersistenceException ex) {
            arguments.add(root.get(attributes[0]));
            startIndex = 1;
        }
        for (int i = startIndex; i < attributes.length; ++i) {
            arguments.add(builder.literal((Object)attributes[i]));
        }
        return isStr ? builder.function("jsonb_extract_path_text", String.class, arguments.toArray(new Expression[arguments.size()])) : builder.function("jsonb_extract_path", Object.class, arguments.toArray(new Expression[arguments.size()]));
    }
}

