/*
 * Decompiled with CFR 0.152.
 */
package https_58_47_47github_46com_47kiegroup_47drools_47kie_45dmn_47__A4BCA8B8_45CF08_45433F_4593B2_45A2598F19ECFF;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.drools.core.util.IoUtils;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.feel.codegen.feel11.CodegenStringUtil;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.kogito.Application;
import org.kie.kogito.decision.DecisionExecutionIdUtils;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.rest.DMNFEELComparablePeriodSerializer;
import org.kie.kogito.dmn.rest.DMNJSONUtils;
import org.kie.kogito.dmn.rest.KogitoDMNResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Traffic Violation"})
public class Traffic_32ViolationResource {
    @Autowired
    Application application;
    private static final String KOGITO_DECISION_INFOWARN_HEADER = "X-Kogito-decision-messages";
    private static final String KOGITO_EXECUTION_ID_HEADER = "X-Kogito-execution-id";
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new SimpleModule().addSerializer(ComparablePeriod.class, (JsonSerializer)new DMNFEELComparablePeriodSerializer())).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);

    @PostMapping(value={""}, produces={"application/json"}, consumes={"application/json"})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/InputSet"))}, description="DMN input")
    @ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/OutputSet"))}, description="DMN output")
    public ResponseEntity<?> dmn(@RequestBody(required=false) Map<String, Object> variables, HttpServletResponse httpResponse) {
        DecisionModel decision = ((DecisionModels)this.application.get(DecisionModels.class)).getDecisionModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        DMNResult decisionResult = decision.evaluateAll(DMNJSONUtils.ctx((DecisionModel)decision, variables));
        this.enrichResponseHeaders(decisionResult, httpResponse);
        KogitoDMNResult result = new KogitoDMNResult("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", decisionResult);
        return this.extractContextIfSucceded(result);
    }

    @GetMapping(produces={"application/xml"})
    public String dmn() throws IOException {
        return new String(IoUtils.readBytesFromInputStream((InputStream)this.getClass().getResourceAsStream(CodegenStringUtil.escapeIdentifier((String)"Traffic Violation") + ".dmn_nologic")));
    }

    private ResponseEntity buildFailedEvaluationResponse(KogitoDMNResult result) {
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)result);
    }

    private ResponseEntity extractContextIfSucceded(KogitoDMNResult result) {
        if (!result.hasErrors()) {
            return ResponseEntity.ok((Object)this.buildResponse((Object)result.getDmnContext()));
        }
        return this.buildFailedEvaluationResponse(result);
    }

    private ResponseEntity extractSingletonDSIfSucceded(KogitoDMNResult result) {
        if (!result.hasErrors()) {
            return ResponseEntity.ok((Object)this.buildResponse(((DMNDecisionResult)result.getDecisionResults().get(0)).getResult()));
        }
        return this.buildFailedEvaluationResponse(result);
    }

    private ResponseEntity buildDMNResultResponse(KogitoDMNResult result) {
        if (!result.hasErrors()) {
            return ResponseEntity.ok((Object)this.buildResponse((Object)result));
        }
        return this.buildFailedEvaluationResponse(result);
    }

    private String buildResponse(Object o) {
        try {
            return objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private void enrichResponseHeaders(DMNResult result, HttpServletResponse httpResponse) {
        if (!result.getMessages().isEmpty()) {
            String infoWarns = result.getMessages().stream().map(m -> m.getLevel() + " " + m.getMessage()).collect(Collectors.joining(", "));
            httpResponse.addHeader(KOGITO_DECISION_INFOWARN_HEADER, infoWarns);
        }
        DecisionExecutionIdUtils.getOptional((DMNContext)result.getContext()).ifPresent(executionId -> httpResponse.addHeader(KOGITO_EXECUTION_ID_HEADER, executionId));
    }

    @PostMapping(value={"dmnresult"}, produces={"application/json"}, consumes={"application/json"})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/InputSet"))}, description="DMN input")
    public ResponseEntity<?> dmn_dmnresult(@RequestBody(required=false) Map<String, Object> variables, HttpServletResponse httpResponse) {
        DecisionModel decision = ((DecisionModels)this.application.get(DecisionModels.class)).getDecisionModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        DMNResult decisionResult = decision.evaluateAll(DMNJSONUtils.ctx((DecisionModel)decision, variables));
        this.enrichResponseHeaders(decisionResult, httpResponse);
        KogitoDMNResult result = new KogitoDMNResult("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", decisionResult);
        return this.buildDMNResultResponse(result);
    }

    @PostMapping(value={"FineService"}, produces={"application/json"}, consumes={"application/json"})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/InputSetDS1"))}, description="DMN input")
    @ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/OutputSetDS1"))}, description="DMN output")
    public ResponseEntity<?> decisionService__FineService(@RequestBody(required=false) Map<String, Object> variables, HttpServletResponse httpResponse) {
        DecisionModel decision = ((DecisionModels)this.application.get(DecisionModels.class)).getDecisionModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        DMNResult decisionResult = decision.evaluateDecisionService(DMNJSONUtils.ctx((DecisionModel)decision, variables, (String)"FineService"), "FineService");
        this.enrichResponseHeaders(decisionResult, httpResponse);
        KogitoDMNResult result = new KogitoDMNResult("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", decisionResult);
        return this.extractSingletonDSIfSucceded(result);
    }

    @PostMapping(value={"FineService/dmnresult"}, produces={"application/json"}, consumes={"application/json"})
    @io.swagger.v3.oas.annotations.parameters.RequestBody(content={@Content(mediaType="application/json", schema=@Schema(ref="/dmnDefinitions.json#/definitions/InputSetDS1"))}, description="DMN input")
    public ResponseEntity<?> decisionService__FineService_dmnresult(@RequestBody(required=false) Map<String, Object> variables, HttpServletResponse httpResponse) {
        DecisionModel decision = ((DecisionModels)this.application.get(DecisionModels.class)).getDecisionModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        DMNResult decisionResult = decision.evaluateDecisionService(DMNJSONUtils.ctx((DecisionModel)decision, variables, (String)"FineService"), "FineService");
        this.enrichResponseHeaders(decisionResult, httpResponse);
        KogitoDMNResult result = new KogitoDMNResult("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", decisionResult);
        return this.buildDMNResultResponse(result);
    }
}

