/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.kogito.quarkus.tracing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@QuarkusTestResource(value=KafkaQuarkusTestResource.class)
public class LoanEligibilityTest {
    private static Logger LOGGER = LoggerFactory.getLogger(LoanEligibilityTest.class);
    public static final String TOPIC_CONSUMER = "kogito-tracing-decision";
    @Inject
    private ObjectMapper objectMapper;
    public KafkaClient kafkaClient;
    @ConfigProperty(name="kafka.bootstrap.servers")
    private String kafkaBootstrapServers;

    @Test
    public void testEvaluateTrafficViolation() throws InterruptedException {
        this.kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.kafkaClient.consume(TOPIC_CONSUMER, s -> {
            LOGGER.info("Received from kafka: {}", s);
            try {
                TraceEvent event = (TraceEvent)this.objectMapper.readValue(s, TraceEvent.class);
                Assertions.assertNotNull((Object)event);
                countDownLatch.countDown();
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error parsing {}", s, (Object)e);
                throw new RuntimeException(e);
            }
        });
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"Client\": {\"age\": 43,\"salary\": 1950,\"existing payments\": 100},\"Loan\": {\"duration\": 15,\"installment\": 180}, \"SupremeDirector\" : \"Yes\", \"Bribe\": 1000}").contentType(ContentType.JSON).when().post("/LoanEligibility", new Object[0])).then()).statusCode(200)).body("'Decide'", Matchers.is((Object)true), new Object[0]);
        countDownLatch.await(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)countDownLatch.getCount(), (long)0L);
    }
}

