/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.kogito.quarkus.tracing;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.kogito.quarkus.tracing.matcher.StringMatchesUUIDPattern;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@QuarkusTestResource(value=KafkaQuarkusTestResource.class)
public class LoanEligibilityIT {
    public static final String KOGITO_EXECUTION_ID_HEADER = "X-Kogito-execution-id";
    public static final String TRACING_TOPIC_NAME = "kogito-tracing-decision";
    public static final String TRACING_MODELS_TOPIC_NAME = "kogito-tracing-model";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoanEligibilityIT.class);
    @ConfigProperty(name="kafka.bootstrap.servers")
    private String kafkaBootstrapServers;

    @Test
    public void testEvaluateLoanEligibility() throws InterruptedException {
        KafkaClient kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            kafkaClient.consume(TRACING_TOPIC_NAME, s -> {
                LOGGER.info("Received from kafka: {}", s);
                Optional.ofNullable(CloudEventUtils.decode((String)s)).ifPresentOrElse(cloudEvent -> countDownLatch.countDown(), () -> LOGGER.error("Error parsing {}", s));
            });
            ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{    \"Client\": {        \"age\": 43,        \"salary\": 1950,        \"existing payments\": 100    },    \"Loan\": {        \"duration\": 15,        \"installment\": 180    },    \"SupremeDirector\" : \"Yes\",    \"Bribe\": 1000}").contentType(ContentType.JSON).when().post("/LoanEligibility", new Object[0])).then()).statusCode(200)).header(KOGITO_EXECUTION_ID_HEADER, StringMatchesUUIDPattern.matchesThePatternOfAUUID())).body("'Decide'", Matchers.is((Object)true), new Object[0]);
            countDownLatch.await(5L, TimeUnit.SECONDS);
            Assertions.assertEquals((long)0L, (long)countDownLatch.getCount());
        }
        finally {
            kafkaClient.shutdown();
        }
    }

    @Test
    public void testEvaluateDMNModel() throws InterruptedException {
        KafkaClient kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            kafkaClient.consume(TRACING_MODELS_TOPIC_NAME, s -> {
                LOGGER.info("Received from kafka: {}", s);
                Optional.ofNullable(CloudEventUtils.decode((String)s)).ifPresentOrElse(cloudEvent -> countDownLatch.countDown(), () -> LOGGER.error("Error parsing {}", s));
            });
            countDownLatch.await(5L, TimeUnit.SECONDS);
            Assertions.assertEquals((long)0L, (long)countDownLatch.getCount());
        }
        finally {
            kafkaClient.shutdown();
        }
    }
}

