/*
 * Decompiled with CFR 0.152.
 */
package org.drools.dynamic.common;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Vector;
import org.drools.reflective.ResourceProvider;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.drools.reflective.util.ClassUtils;

public class DynamicProjectClassLoader
extends ProjectClassLoader {
    private static boolean isIBM_JVM = System.getProperty("java.vendor").toLowerCase().contains("ibm");

    protected DynamicProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        super(parent, resourceProvider);
    }

    public static DynamicProjectClassLoader create(ClassLoader parent, ResourceProvider resourceProvider) {
        return isIBM_JVM ? new IBMDynamicClassLoader(parent, resourceProvider) : new DynamicProjectClassLoader(parent, resourceProvider);
    }

    public ProjectClassLoader.InternalTypesClassLoader makeClassLoader() {
        return AccessController.doPrivileged(() -> ClassUtils.isAndroid() ? (ProjectClassLoader.InternalTypesClassLoader)ClassUtils.instantiateObject((String)"org.drools.android.DexInternalTypesClassLoader", null, (Object[])new Object[]{this}) : new DefaultInternalTypesClassLoader(this));
    }

    private static class DefaultInternalTypesClassLoader
    extends ClassLoader
    implements ProjectClassLoader.InternalTypesClassLoader {
        private final ProjectClassLoader projectClassLoader;

        private DefaultInternalTypesClassLoader(ProjectClassLoader projectClassLoader) {
            super(projectClassLoader.getParent());
            this.projectClassLoader = projectClassLoader;
        }

        public Class<?> defineClass(String name, byte[] bytecode) {
            String pkgName;
            int lastDot = name.lastIndexOf(46);
            if (lastDot > 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, "", "", "", "", "", "", null);
            }
            return this.defineClass(name, bytecode, 0, bytecode.length);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return this.loadType(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    return this.projectClassLoader.internalLoadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe2) {
                    return this.projectClassLoader.tryDefineType(name, cnfe);
                }
            }
        }

        public Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        @Override
        public URL getResource(String name) {
            return this.projectClassLoader.getResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.projectClassLoader.getResourceAsStream(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.projectClassLoader.getResources(name);
        }

        static {
            DefaultInternalTypesClassLoader.registerAsParallelCapable();
        }
    }

    public static class IBMDynamicClassLoader
    extends DynamicProjectClassLoader {
        private final boolean parentImplementsFindResources;
        private static final Enumeration<URL> EMPTY_RESOURCE_ENUM = new Vector().elements();

        private IBMDynamicClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
            super(parent, resourceProvider);
            Method m = null;
            try {
                m = parent.getClass().getMethod("findResources", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.parentImplementsFindResources = m != null && m.getDeclaringClass() == parent.getClass();
        }

        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.parentImplementsFindResources ? EMPTY_RESOURCE_ENUM : this.getParent().getResources(name);
        }
    }
}

