/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.util.Collection;
import java.util.stream.Collectors;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.util.Drools;
import org.drools.model.Model;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.modelcompiler.builder.KieModuleModelMethod;
import org.drools.modelcompiler.builder.PackageModel;
import org.kie.api.builder.ReleaseId;

public class ModelSourceClass {
    private final Collection<String> modelSources;
    private final KieModuleModelMethod modelMethod;
    private final ReleaseId releaseId;

    public ModelSourceClass(ReleaseId releaseId, KieModuleModelMethod modelMethod, Collection<String> modelSources) {
        this.releaseId = releaseId;
        this.modelSources = modelSources;
        this.modelMethod = modelMethod;
    }

    public void write(MemoryFileSystem srcMfs) {
        srcMfs.write(CanonicalModelKieProject.PROJECT_MODEL_SOURCE, PackageModel.log(this.generate()).getBytes());
    }

    public String generate() {
        StringBuilder sb = new StringBuilder();
        sb.append("package org.drools.project.model;\n\nimport " + Model.class.getCanonicalName() + ";\nimport " + ReleaseId.class.getCanonicalName() + ";\nimport " + ReleaseIdImpl.class.getCanonicalName() + ";\n\npublic class ProjectModel implements org.drools.modelcompiler.CanonicalKieModuleModel {\n\n");
        sb.append("    @Override\n    public String getVersion() {\n        return \"");
        sb.append(Drools.getFullVersion());
        sb.append("\";\n    }\n\n    @Override\n    public java.util.List<Model> getModels() {\n        return java.util.Arrays.asList(");
        sb.append(this.modelSources.isEmpty() ? "" : this.modelSources.stream().collect(Collectors.joining("(), new ", "new ", "()")));
        sb.append(");\n    }\n\n    @Override\n    public ReleaseId getReleaseId() {\n        return new ReleaseIdImpl(\"");
        sb.append(this.releaseId.getGroupId()).append("\", \"");
        sb.append(this.releaseId.getArtifactId()).append("\", \"");
        sb.append(this.releaseId.getVersion()).append("\"");
        sb.append(");\n    }\n");
        sb.append("\n");
        sb.append(this.modelMethod.toGetKieModuleModelMethod());
        sb.append("\n}");
        return sb.toString();
    }
}

