/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Tuple;
import org.drools.model.Binding;

public class BindingEvaluator {
    private final Declaration[] declarations;
    private final Binding binding;

    public BindingEvaluator(Declaration[] declarations, Binding binding) {
        this.declarations = declarations;
        this.binding = binding;
    }

    public Object evaluate(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory, Declaration[] declarations, Declaration[] innerDeclarations) {
        return this.evaluate(this.getArguments(handle, tuple, workingMemory, declarations, innerDeclarations));
    }

    public Object evaluate(Object ... args) {
        return this.binding.eval(args);
    }

    public Declaration[] getDeclarations() {
        return this.declarations;
    }

    protected Object[] getArguments(InternalFactHandle handle, Tuple tuple, InternalWorkingMemory workingMemory, Declaration[] declarations, Declaration[] innerDeclarations) {
        int i;
        Object[] params = new Object[declarations.length + innerDeclarations.length];
        for (i = 0; i < innerDeclarations.length; ++i) {
            params[i] = this.getArgument(handle, workingMemory, innerDeclarations[i], tuple);
        }
        for (i = 0; i < declarations.length; ++i) {
            params[i + innerDeclarations.length] = this.getArgument(handle, workingMemory, declarations[i], tuple);
        }
        return params;
    }

    public Object getArgument(InternalFactHandle handle, InternalWorkingMemory workingMemory, Declaration declaration, Tuple tuple) {
        Object object = tuple != null && declaration.getPattern().getOffset() < tuple.size() ? tuple.getObject(declaration.getPattern().getOffset()) : handle.getObject();
        return declaration.getValue(workingMemory, object);
    }
}

