/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.constraint.parser.ast.expr.DrlNameExpr;
import org.drools.constraint.parser.printer.PrintUtil;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternDSLPattern;

class PatternAccumulateConstraint
implements DSLNode {
    private final RuleContext context;
    private final PackageModel packageModel;
    private final PatternDescr pattern;
    private final AccumulateDescr source;
    private final List<? extends BaseDescr> constraintDescrs;

    public PatternAccumulateConstraint(RuleContext context, PackageModel packageModel, PatternDescr pattern, AccumulateDescr source, List<? extends BaseDescr> constraintDescrs) {
        this.context = context;
        this.packageModel = packageModel;
        this.pattern = pattern;
        this.source = source;
        this.constraintDescrs = constraintDescrs;
    }

    @Override
    public void buildPattern() {
        HashMap<String, List> constraintsByVar = new HashMap<String, List>();
        block0: for (BaseDescr baseDescr : this.constraintDescrs) {
            Set exprIds = DrlxParseUtil.parseExpression(baseDescr.getText()).getExpr().findAll(DrlNameExpr.class).stream().map(PrintUtil::printConstraint).collect(Collectors.toSet());
            for (AccumulateDescr.AccumulateFunctionCallDescr accFunc : this.source.getFunctions()) {
                if (!exprIds.contains(accFunc.getBind())) continue;
                constraintsByVar.computeIfAbsent(accFunc.getBind(), s -> new ArrayList()).add(baseDescr);
                continue block0;
            }
        }
        constraintsByVar.forEach((id, constraints) -> {
            this.pattern.setIdentifier(id);
            new PatternDSLPattern(this.context, this.packageModel, this.pattern, (List<? extends BaseDescr>)constraints, null, false).buildPattern();
        });
        this.pattern.setIdentifier(null);
    }
}

