/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.model.Model;
import org.drools.modelcompiler.builder.CanonicalModelKieProject;
import org.drools.modelcompiler.builder.KieModuleModelMethod;
import org.drools.modelcompiler.builder.PackageModel;
import org.kie.api.KieBase;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.runtime.KieSession;
import org.kie.kogito.rules.KieRuntimeBuilder;

public class ProjectSourceClass {
    final KieModuleModelMethod modelMethod;
    private String dependencyInjection = "";

    public ProjectSourceClass(KieModuleModelMethod modelMethod) {
        this.modelMethod = modelMethod;
    }

    public ProjectSourceClass withDependencyInjection(String dependencyInjection) {
        this.dependencyInjection = dependencyInjection;
        return this;
    }

    public String generate() {
        StringBuilder sb = new StringBuilder();
        sb.append("package org.drools.project.model;\n\nimport " + Model.class.getCanonicalName() + ";\nimport " + KieBase.class.getCanonicalName() + ";\nimport " + KieBaseModel.class.getCanonicalName() + ";\nimport " + KieSession.class.getCanonicalName() + ";\n\n" + this.dependencyInjection + "\npublic class ProjectRuntime implements " + KieRuntimeBuilder.class.getCanonicalName() + " {\n\n");
        sb.append(this.modelMethod.getConstructor());
        sb.append("\n");
        sb.append(this.modelMethod.toNewKieSessionMethod());
        sb.append("\n");
        sb.append(this.modelMethod.toGetKieBaseForSessionMethod());
        sb.append("\n");
        sb.append(this.modelMethod.toKieSessionConfMethod());
        sb.append("\n}");
        return sb.toString();
    }

    public void write(MemoryFileSystem srcMfs) {
        srcMfs.write(this.getName(), PackageModel.log(this.generate()).getBytes());
    }

    public String getName() {
        return CanonicalModelKieProject.PROJECT_RUNTIME_SOURCE;
    }
}

