/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.model.BitMask;
import org.drools.model.bitmask.AllSetButLastBitMask;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.CompilationProblemErrorResult;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.errors.MvelCompilationError;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.consequence.DroolsImpl;
import org.drools.modelcompiler.util.ClassUtil;
import org.drools.mvel.parser.printer.PrintUtil;
import org.drools.mvelcompiler.ModifyCompiler;
import org.drools.mvelcompiler.MvelCompiler;
import org.drools.mvelcompiler.MvelCompilerException;
import org.drools.mvelcompiler.ParsingResult;
import org.drools.mvelcompiler.context.MvelCompilerContext;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class Consequence {
    public static final Set<String> knowledgeHelperMethods = new HashSet<String>();
    public static final Set<String> implicitDroolsMethods = new HashSet<String>();
    private final RuleContext context;
    private final PackageModel packageModel;

    private Expression createAsKnowledgeHelperExpression() {
        return StaticJavaParser.parseExpression((String)String.format("((%s) drools).asKnowledgeHelper()", DroolsImpl.class.getCanonicalName()));
    }

    public Consequence(RuleContext context) {
        this.context = context;
        this.packageModel = context.getPackageModel();
    }

    public MethodCallExpr createCall(RuleDescr ruleDescr, String consequenceString, BlockStmt ruleVariablesBlock, boolean isBreaking) {
        BlockStmt ruleConsequence = null;
        if (this.context.getRuleDialect() == RuleContext.RuleDialect.JAVA) {
            ruleConsequence = this.rewriteConsequence(consequenceString);
            if (ruleConsequence != null) {
                ruleConsequence.findAll(Expression.class).stream().filter(s -> DrlxParseUtil.isNameExprWithName((Node)s, "kcontext")).forEach(n -> n.replace((Node)new CastExpr((Type)DrlxParseUtil.toClassOrInterfaceType(org.kie.api.runtime.rule.RuleContext.class), (Expression)new NameExpr("drools"))));
            } else {
                return null;
            }
        }
        Set<String> usedDeclarationInRHS = this.extractUsedDeclarations(ruleConsequence, consequenceString);
        HashSet<String> usedUnusableDeclarations = new HashSet<String>(this.context.getUnusableOrBinding());
        usedUnusableDeclarations.retainAll(usedDeclarationInRHS);
        for (String s2 : usedUnusableDeclarations) {
            this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult(String.format("%s cannot be resolved to a variable", s2)));
        }
        MethodCallExpr onCall = this.onCall(usedDeclarationInRHS);
        if (isBreaking) {
            onCall = new MethodCallExpr((Expression)onCall, "breaking");
        }
        MethodCallExpr executeCall = null;
        if (this.context.getRuleDialect() == RuleContext.RuleDialect.JAVA) {
            executeCall = this.executeCall(ruleVariablesBlock, ruleConsequence, usedDeclarationInRHS, onCall, Collections.emptySet());
        } else if (this.context.getRuleDialect() == RuleContext.RuleDialect.MVEL) {
            executeCall = this.createExecuteCallMvel(ruleDescr, ruleVariablesBlock, usedDeclarationInRHS, onCall);
        }
        return executeCall;
    }

    private MethodCallExpr createExecuteCallMvel(RuleDescr ruleDescr, BlockStmt ruleVariablesBlock, Set<String> usedDeclarationInRHS, MethodCallExpr onCall) {
        ParsingResult compile;
        String mvelBlock = DrlxParseUtil.addCurlyBracesToBlock(ruleDescr.getConsequence().toString());
        MvelCompilerContext mvelCompilerContext = new MvelCompilerContext(this.context.getTypeResolver());
        for (DeclarationSpec d : this.context.getAllDeclarations()) {
            Class<?> clazz = DrlxParseUtil.getClassFromType(this.context.getTypeResolver(), d.getRawType());
            mvelCompilerContext.addDeclaration(d.getBindingId(), clazz);
        }
        try {
            compile = new MvelCompiler(mvelCompilerContext).compile(mvelBlock);
        }
        catch (MvelCompilerException e) {
            this.context.addCompilationError((KnowledgeBuilderResult)new CompilationProblemErrorResult(new MvelCompilationError(e)));
            return null;
        }
        return this.executeCall(ruleVariablesBlock, compile.statementResults(), usedDeclarationInRHS, onCall, compile.getUsedBindings());
    }

    private BlockStmt rewriteConsequence(String consequence) {
        String ruleConsequenceAsBlock = this.rewriteModifyBlock(consequence.trim());
        try {
            return DrlxParseUtil.parseBlock(ruleConsequenceAsBlock);
        }
        catch (ParseProblemException e) {
            this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unable to parse consequence caused by: " + e.getMessage()));
            return null;
        }
    }

    private Set<String> extractUsedDeclarations(BlockStmt ruleConsequence, String consequenceString) {
        HashSet<String> existingDecls = new HashSet<String>();
        existingDecls.addAll(this.context.getAvailableBindings());
        existingDecls.addAll(this.packageModel.getGlobals().keySet());
        if (this.context.getRuleUnitDescr() != null) {
            existingDecls.addAll(this.context.getRuleUnitDescr().getUnitVars());
        }
        if (this.context.getRuleDialect() == RuleContext.RuleDialect.MVEL) {
            return existingDecls.stream().filter(d -> Consequence.containsWord(d, consequenceString)).collect(Collectors.toSet());
        }
        Set declUsedInRHS = ruleConsequence.findAll(NameExpr.class).stream().map(NodeWithSimpleName::getNameAsString).collect(Collectors.toSet());
        return existingDecls.stream().filter(declUsedInRHS::contains).collect(Collectors.toSet());
    }

    public static boolean containsWord(String word, String body) {
        String wordWithDollarReplaced = word.replace("$", "\u72ac");
        String bodyWithDollarReplaced = body.replace("$", "\u72ac");
        Pattern p = Pattern.compile("\\b" + wordWithDollarReplaced + "\\b");
        Matcher m = p.matcher(bodyWithDollarReplaced);
        return m.find();
    }

    private MethodCallExpr executeCall(BlockStmt ruleVariablesBlock, BlockStmt ruleConsequence, Collection<String> verifiedDeclUsedInRHS, MethodCallExpr onCall, Set<String> modifyProperties) {
        for (String modifiedProperty : modifyProperties) {
            NodeList arguments = NodeList.nodeList((Node[])new Expression[]{new NameExpr(modifiedProperty)});
            MethodCallExpr update = new MethodCallExpr((Expression)new NameExpr("drools"), "update", arguments);
            ruleConsequence.getStatements().add((Node)new ExpressionStmt((Expression)update));
        }
        boolean requireDrools = this.rewriteRHS(ruleVariablesBlock, ruleConsequence);
        MethodCallExpr executeCall = new MethodCallExpr((Expression)onCall, onCall == null ? "D.execute" : "execute");
        LambdaExpr executeLambda = new LambdaExpr();
        executeCall.addArgument((Expression)executeLambda);
        executeLambda.setEnclosingParameters(true);
        if (requireDrools) {
            executeLambda.addParameter(new Parameter((Type)new UnknownType(), "drools"));
        }
        verifiedDeclUsedInRHS.stream().map(x -> new Parameter((Type)new UnknownType(), x)).forEach(arg_0 -> ((LambdaExpr)executeLambda).addParameter(arg_0));
        executeLambda.setBody((Statement)ruleConsequence);
        return executeCall;
    }

    private MethodCallExpr onCall(Collection<String> usedArguments) {
        MethodCallExpr onCall = null;
        if (!usedArguments.isEmpty()) {
            onCall = new MethodCallExpr(null, "D.on");
            usedArguments.stream().map(this.context::getVar).forEach(arg_0 -> ((MethodCallExpr)onCall).addArgument(arg_0));
        }
        return onCall;
    }

    private String rewriteModifyBlock(String consequence) {
        int modifyPos = StringUtils.indexOfOutOfQuotes((String)consequence, (String)"modify");
        if (modifyPos < 0) {
            return consequence;
        }
        ModifyCompiler modifyCompiler = new ModifyCompiler();
        ParsingResult compile = modifyCompiler.compile(DrlxParseUtil.addCurlyBracesToBlock(consequence));
        return PrintUtil.printConstraint((Node)compile.statementResults());
    }

    private boolean rewriteRHS(BlockStmt ruleBlock, BlockStmt rhs) {
        AtomicBoolean requireDrools = new AtomicBoolean(false);
        List methodCallExprs = rhs.findAll(MethodCallExpr.class);
        ArrayList<MethodCallExpr> updateExprs = new ArrayList<MethodCallExpr>();
        HashMap<String, String> newDeclarations = new HashMap<String, String>();
        for (VariableDeclarator variableDeclarator : rhs.findAll(VariableDeclarator.class)) {
            variableDeclarator.getInitializer().ifPresent(init -> newDeclarations.put(variableDeclarator.getNameAsString(), init.toString()));
        }
        for (MethodCallExpr methodCallExpr : methodCallExprs) {
            if (!Consequence.isDroolsMethod(methodCallExpr)) continue;
            if (!methodCallExpr.getScope().isPresent()) {
                methodCallExpr.setScope((Expression)new NameExpr("drools"));
            }
            if (knowledgeHelperMethods.contains(methodCallExpr.getNameAsString())) {
                methodCallExpr.setScope(this.createAsKnowledgeHelperExpression());
            } else if (methodCallExpr.getNameAsString().equals("update")) {
                if (methodCallExpr.toString().contains("FactHandle")) {
                    methodCallExpr.setScope((Expression)new NameExpr("((org.drools.modelcompiler.consequence.DroolsImpl) drools)"));
                }
                updateExprs.add(methodCallExpr);
            } else if (methodCallExpr.getNameAsString().equals("retract")) {
                methodCallExpr.setName(new SimpleName("delete"));
            }
            requireDrools.set(true);
        }
        HashSet<String> initializedBitmaskFields = new HashSet<String>();
        for (MethodCallExpr updateExpr : updateExprs) {
            Expression argExpr = updateExpr.getArgument(0);
            if (!(argExpr instanceof NameExpr)) continue;
            String updatedVar = ((NameExpr)argExpr).getNameAsString();
            Set<String> modifiedProps = this.findModifiedProperties(methodCallExprs, updateExpr, updatedVar);
            if (!initializedBitmaskFields.contains(updatedVar)) {
                MethodCallExpr bitMaskCreation = this.createBitMaskInitialization(newDeclarations, updatedVar, modifiedProps);
                ruleBlock.addStatement((Expression)this.createBitMaskField(updatedVar, bitMaskCreation));
            }
            updateExpr.addArgument("mask_" + updatedVar);
            initializedBitmaskFields.add(updatedVar);
        }
        return requireDrools.get();
    }

    private MethodCallExpr createBitMaskInitialization(Map<String, String> newDeclarations, String updatedVar, Set<String> modifiedProps) {
        MethodCallExpr bitMaskCreation;
        if (modifiedProps != null && !modifiedProps.isEmpty()) {
            String declarationVar = newDeclarations.getOrDefault(updatedVar, updatedVar);
            Class updatedClass = this.context.getDeclarationById(declarationVar).map(DeclarationSpec::getDeclarationClass).orElseThrow(RuntimeException::new);
            String domainClassSourceName = ClassUtil.asJavaSourceName(updatedClass);
            bitMaskCreation = new MethodCallExpr((Expression)new NameExpr(BitMask.class.getCanonicalName()), "getPatternMask");
            bitMaskCreation.addArgument("DomainClassesMetadata" + this.packageModel.getPackageUUID() + "." + domainClassSourceName + "_Metadata_INSTANCE");
            modifiedProps.forEach(s -> {
                MethodCallExpr cfr_ignored_0 = (MethodCallExpr)bitMaskCreation.addArgument((Expression)new StringLiteralExpr(s));
            });
        } else {
            bitMaskCreation = new MethodCallExpr((Expression)new NameExpr(AllSetButLastBitMask.class.getCanonicalName()), "get");
        }
        return bitMaskCreation;
    }

    private AssignExpr createBitMaskField(String updatedVar, MethodCallExpr bitMaskCreation) {
        VariableDeclarationExpr bitMaskVar = new VariableDeclarationExpr((Type)DrlxParseUtil.toClassOrInterfaceType(BitMask.class), "mask_" + updatedVar, new Modifier[]{Modifier.finalModifier()});
        return new AssignExpr((Expression)bitMaskVar, (Expression)bitMaskCreation, AssignExpr.Operator.ASSIGN);
    }

    private Set<String> findModifiedProperties(List<MethodCallExpr> methodCallExprs, MethodCallExpr updateExpr, String updatedVar) {
        HashSet<String> modifiedProps = new HashSet<String>();
        for (MethodCallExpr methodCall : methodCallExprs.subList(0, methodCallExprs.indexOf(updateExpr))) {
            DrlxParseUtil.RemoveRootNodeResult removeRootNodeViaScope = DrlxParseUtil.findRemoveRootNodeViaScope((Expression)methodCall);
            Optional<Expression> root = removeRootNodeViaScope.getRootNode().filter(s -> DrlxParseUtil.isNameExprWithName((Node)s, updatedVar));
            if (!methodCall.getScope().isPresent() || !root.isPresent()) continue;
            String propName = this.methodToProperty(methodCall, removeRootNodeViaScope.getFirstChild());
            if (propName != null) {
                modifiedProps.add(propName);
                continue;
            }
            return null;
        }
        return modifiedProps;
    }

    private String methodToProperty(MethodCallExpr mce, Expression getter) {
        String propertyName = ClassUtils.setter2property((String)mce.getNameAsString());
        if (propertyName == null && getter.isMethodCallExpr()) {
            propertyName = ClassUtils.getter2property((String)getter.asMethodCallExpr().getNameAsString());
        }
        return propertyName;
    }

    private static boolean isDroolsMethod(MethodCallExpr mce) {
        boolean hasDroolsScope = DrlxParseUtil.hasScopeWithName(mce, "drools");
        boolean isImplicitDroolsMethod = !mce.getScope().isPresent() && implicitDroolsMethods.contains(mce.getNameAsString());
        boolean hasDroolsAsParameter = DrlxParseUtil.findAllChildrenRecursive((Expression)mce).stream().anyMatch(a -> DrlxParseUtil.isNameExprWithName(a, "drools"));
        return hasDroolsScope || isImplicitDroolsMethod || hasDroolsAsParameter;
    }

    static {
        implicitDroolsMethods.add("insert");
        implicitDroolsMethods.add("insertLogical");
        implicitDroolsMethods.add("delete");
        implicitDroolsMethods.add("retract");
        implicitDroolsMethods.add("update");
        knowledgeHelperMethods.add("getWorkingMemory");
        knowledgeHelperMethods.add("getRule");
        knowledgeHelperMethods.add("getTuple");
        knowledgeHelperMethods.add("getKnowledgeRuntime");
        knowledgeHelperMethods.add("getKieRuntime");
        knowledgeHelperMethods.add("insertLogical");
        knowledgeHelperMethods.add("run");
        knowledgeHelperMethods.add("guard");
    }
}

