/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process;

import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import org.kie.kogito.resources.ConditionHolder;
import org.kie.kogito.resources.ConditionalTestResource;

public class LocalProcessTestResource
implements ConditionalTestResource<LocalProcessTestResource> {
    private URL resource;
    private Process process;
    private final ConditionHolder condition;
    private final String jvmArguments;

    public LocalProcessTestResource(String name, String path, String jvmArguments) {
        this.resource = this.getClass().getClassLoader().getResource(path);
        this.condition = new ConditionHolder(name);
        this.jvmArguments = jvmArguments;
    }

    @Override
    public void start() {
        if (!this.condition.isEnabled()) {
            return;
        }
        String separator = System.getProperty("file.separator");
        String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
        ProcessBuilder processBuilder = new ProcessBuilder(path, this.jvmArguments, "-jar", this.resource.getPath());
        try {
            this.process = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        Optional.ofNullable(this.process).ifPresent(Process::destroy);
    }

    @Override
    public LocalProcessTestResource enableConditional() {
        this.condition.enableConditional();
        return this;
    }
}

