/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.time.Duration;
import java.util.function.Consumer;
import org.kie.kogito.testcontainers.ConditionalGenericContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;

public class KeycloakContainer
extends ConditionalGenericContainer<KeycloakContainer> {
    public static final String NAME = "keycloak";
    public static final String KEYCLOAK_PROPERTY = "container.image.keycloak";
    private static final String REALM_FILE = "/tmp/realm.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakContainer.class);

    public KeycloakContainer() {
        this.addFixedExposedPort(8281, 8080);
        this.withEnv("KEYCLOAK_USER", "admin");
        this.withEnv("KEYCLOAK_PASSWORD", "admin");
        this.withEnv("KEYCLOAK_IMPORT", REALM_FILE);
        this.withClasspathResourceMapping("testcontainers/keycloak/kogito-realm.json", REALM_FILE, BindMode.READ_ONLY);
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.waitingFor(Wait.forHttp((String)"/auth").withStartupTimeout(Duration.ofMinutes(5L)));
    }

    @Override
    protected String getResourceName() {
        return NAME;
    }

    @Override
    protected void preStart() {
        this.setDockerImageName(System.getProperty(KEYCLOAK_PROPERTY));
    }
}

