/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.util.function.Consumer;
import org.kie.kogito.resources.ConditionHolder;
import org.kie.kogito.resources.ConditionalTestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;

public class KogitoKafkaContainer
extends KafkaContainer
implements ConditionalTestResource<KogitoKafkaContainer> {
    public static final String NAME = "kafka";
    public static final String QUARKUS_KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    public static final String SPRINGBOOT_KAFKA_BOOTSTRAP_SERVERS = "spring.kafka.bootstrap-servers";
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoKafkaContainer.class);
    private final ConditionHolder condition = new ConditionHolder("kafka");

    public KogitoKafkaContainer() {
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
    }

    @Override
    public void start() {
        if (this.condition.isEnabled()) {
            super.start();
            System.setProperty(QUARKUS_KAFKA_BOOTSTRAP_SERVERS, this.getBootstrapServers());
            System.setProperty(SPRINGBOOT_KAFKA_BOOTSTRAP_SERVERS, this.getBootstrapServers());
            LOGGER.info("Kafka servers: {}", (Object)this.getBootstrapServers());
        }
    }

    @Override
    public void stop() {
        if (this.condition.isEnabled()) {
            super.stop();
            System.clearProperty(QUARKUS_KAFKA_BOOTSTRAP_SERVERS);
            System.clearProperty(SPRINGBOOT_KAFKA_BOOTSTRAP_SERVERS);
        }
    }

    @Override
    public KogitoKafkaContainer enableConditional() {
        this.condition.enableConditional();
        return this;
    }
}

