/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resources;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.resources.ConditionHolder;
import org.kie.kogito.resources.TestResource;

public abstract class ConditionalQuarkusTestResource
implements QuarkusTestResourceLifecycleManager {
    private final TestResource testResource;
    private final ConditionHolder condition;

    public ConditionalQuarkusTestResource(TestResource testResource) {
        this.testResource = testResource;
        this.condition = new ConditionHolder(testResource.getResourceName());
    }

    public Map<String, String> start() {
        if (this.condition.isEnabled()) {
            this.testResource.start();
            return Collections.singletonMap(this.getKogitoProperty(), this.getKogitoPropertyValue());
        }
        return Collections.emptyMap();
    }

    public void stop() {
        if (this.condition.isEnabled()) {
            this.testResource.stop();
        }
    }

    public void inject(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                ConfigProperty configProperty = f.getAnnotation(ConfigProperty.class);
                if (configProperty == null || !this.getKogitoProperty().equals(configProperty.name())) continue;
                f.setAccessible(true);
                try {
                    f.set(testInstance, this.getKogitoPropertyValue());
                    return;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected abstract String getKogitoProperty();

    protected String getKogitoPropertyValue() {
        return "localhost:" + this.testResource.getMappedPort();
    }

    protected TestResource getTestResource() {
        return this.testResource;
    }

    protected void enableConditional() {
        this.condition.enableConditional();
    }
}

