/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.resources.process;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Optional;
import javax.net.ServerSocketFactory;
import org.kie.kogito.resources.TestResource;

public class LocalQuarkusProcessTestResource
implements TestResource {
    private static final int PORT_RANGE_MIN = 1024;
    private static final int PORT_RANGE_MAX = 65535;
    private static final SecureRandom RND = new SecureRandom();
    private static final String QUARKUS_HTTP_PORT = "quarkus.http.port";
    private final String name;
    private final URL resource;
    private int port;
    private Process process;

    public LocalQuarkusProcessTestResource(String name, String path) {
        this.name = name;
        this.resource = this.getClass().getClassLoader().getResource(path);
    }

    @Override
    public void start() {
        this.port = this.findAvailablePort();
        String separator = System.getProperty("file.separator");
        String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
        ProcessBuilder processBuilder = new ProcessBuilder(path, String.format("-D%s=%s", QUARKUS_HTTP_PORT, this.getMappedPort()), "-jar", this.resource.getPath());
        try {
            this.process = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        Optional.ofNullable(this.process).ifPresent(Process::destroy);
    }

    @Override
    public String getResourceName() {
        return this.name;
    }

    @Override
    public int getMappedPort() {
        return this.port;
    }

    protected int findAvailablePort() {
        int candidatePort;
        int portRange = 64511;
        int searchCounter = 0;
        do {
            if (searchCounter > portRange) {
                throw new IllegalStateException(String.format("Could not find an available %s port in the range [%d, %d] after %d attempts", this.name, 1024, 65535, searchCounter));
            }
            candidatePort = this.findRandomPort(1024, 65535);
            ++searchCounter;
        } while (!this.isPortAvailable(candidatePort));
        return candidatePort;
    }

    private int findRandomPort(int minPort, int maxPort) {
        int portRange = maxPort - minPort;
        return minPort + RND.nextInt(portRange + 1);
    }

    private boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

