/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.time.Duration;
import java.util.function.Consumer;
import org.kie.kogito.resources.TestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer>
implements TestResource {
    public static final String NAME = "keycloak";
    public static final String KEYCLOAK_PROPERTY = "container.image.keycloak";
    public static final int PORT = 8080;
    private static final String REALM_FILE = "/tmp/realm.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakContainer.class);

    public KeycloakContainer() {
        this.addExposedPort(8080);
        this.withEnv("KEYCLOAK_USER", "admin");
        this.withEnv("KEYCLOAK_PASSWORD", "admin");
        this.withEnv("KEYCLOAK_IMPORT", REALM_FILE);
        this.withClasspathResourceMapping("testcontainers/keycloak/kogito-realm.json", REALM_FILE, BindMode.READ_ONLY);
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.waitingFor(Wait.forHttp((String)"/auth").withStartupTimeout(Duration.ofMinutes(5L)));
    }

    @Override
    public int getMappedPort() {
        return this.getMappedPort(8080);
    }

    @Override
    public String getResourceName() {
        return NAME;
    }

    @Override
    public void start() {
        this.setDockerImageName(System.getProperty(KEYCLOAK_PROPERTY));
        super.start();
    }
}

