/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.kafka;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaClient {
    private static Logger LOGGER = LoggerFactory.getLogger(KafkaClient.class);
    private KafkaProducer<String, String> producer;
    private KafkaConsumer<String, String> consumer;
    private CountDownLatch shutdownLatch = new CountDownLatch(1);
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public KafkaClient(String hosts) {
        Properties producerConfig = new Properties();
        producerConfig.put("bootstrap.servers", hosts);
        producerConfig.put("client.id", this.getClass().getName() + "Producer");
        producerConfig.put("key.serializer", IntegerSerializer.class.getName());
        producerConfig.put("value.serializer", StringSerializer.class.getName());
        this.producer = new KafkaProducer(producerConfig);
        Properties consumerConfig = new Properties();
        consumerConfig.put("enable.auto.commit", "true");
        consumerConfig.put("auto.offset.reset", "earliest");
        consumerConfig.put("bootstrap.servers", hosts);
        consumerConfig.put("key.deserializer", IntegerDeserializer.class.getName());
        consumerConfig.put("value.deserializer", StringDeserializer.class.getName());
        consumerConfig.put("group.id", this.getClass().getName() + "Consumer");
        this.consumer = new KafkaConsumer(consumerConfig);
    }

    public void consume(String topic, Consumer<String> callback) {
        this.consumer.subscribe(Collections.singletonList(topic));
        CompletableFuture.runAsync(() -> {
            while (!this.shutdown.get()) {
                ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
                StreamSupport.stream(records.spliterator(), true).map(ConsumerRecord::value).forEach(callback::accept);
                this.consumer.commitSync();
            }
            this.shutdownLatch.countDown();
        });
    }

    public void produce(String data, String topic) {
        this.producer.send(new ProducerRecord(topic, (Object)data), (m, ex) -> Optional.ofNullable(ex).ifPresent(e -> LOGGER.error("Error publishing message {}", (Object)m, (Object)ex)));
    }

    public void shutdown() {
        CompletableFuture.runAsync(() -> this.producer.close());
        try {
            this.shutdown.set(true);
            this.shutdownLatch.await(1L, TimeUnit.MINUTES);
            this.consumer.close();
        }
        catch (InterruptedException e) {
            LOGGER.error("Error shutting down kafka consumer/producer", (Throwable)e);
        }
    }
}

