/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.CounterfactualDomainCategoricalDto;
import org.kie.kogito.explainability.api.CounterfactualDomainDto;
import org.kie.kogito.explainability.api.CounterfactualDomainRangeDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainUnitDto;

public class CounterfactualDomainDtoSerialisationTest {
    private ObjectMapper mapper;
    private StringWriter writer;

    @BeforeEach
    public void setup() {
        this.mapper = new ObjectMapper();
        this.writer = new StringWriter();
    }

    @Test
    public void testCounterfactualSearchDomain_Range_RoundTrip() throws Exception {
        CounterfactualDomainRangeDto domainRangeDto = new CounterfactualDomainRangeDto((JsonNode)new IntNode(18), (JsonNode)new IntNode(65));
        CounterfactualSearchDomainUnitDto searchDomainDto = new CounterfactualSearchDomainUnitDto("integer", Boolean.TRUE, (CounterfactualDomainDto)domainRangeDto);
        this.mapper.writeValue((Writer)this.writer, (Object)searchDomainDto);
        String searchDomainJson = this.writer.toString();
        Assertions.assertNotNull((Object)searchDomainJson);
        CounterfactualSearchDomainDto roundTrippedSearchDomainDto = (CounterfactualSearchDomainDto)this.mapper.readValue(searchDomainJson, CounterfactualSearchDomainDto.class);
        Assertions.assertTrue((boolean)(roundTrippedSearchDomainDto instanceof CounterfactualSearchDomainUnitDto));
        CounterfactualSearchDomainUnitDto roundTrippedSearchDomainUnitDto = (CounterfactualSearchDomainUnitDto)roundTrippedSearchDomainDto;
        Assertions.assertEquals((Object)searchDomainDto.getKind(), (Object)roundTrippedSearchDomainUnitDto.getKind());
        Assertions.assertEquals((Object)searchDomainDto.getType(), (Object)roundTrippedSearchDomainUnitDto.getType());
        Assertions.assertEquals((Object)searchDomainDto.isFixed(), (Object)roundTrippedSearchDomainUnitDto.isFixed());
        Assertions.assertTrue((boolean)(roundTrippedSearchDomainUnitDto.getDomain() instanceof CounterfactualDomainRangeDto));
        CounterfactualDomainRangeDto roundTrippedDomainRangeDto = (CounterfactualDomainRangeDto)roundTrippedSearchDomainUnitDto.getDomain();
        Assertions.assertEquals((Object)domainRangeDto.getLowerBound(), (Object)roundTrippedDomainRangeDto.getLowerBound());
        Assertions.assertEquals((Object)domainRangeDto.getUpperBound(), (Object)roundTrippedDomainRangeDto.getUpperBound());
    }

    @Test
    public void testCounterfactualSearchDomain_Categorical_RoundTrip() throws Exception {
        CounterfactualDomainCategoricalDto domainCategoricalDto = new CounterfactualDomainCategoricalDto(List.of(new TextNode("A"), new TextNode("B")));
        CounterfactualSearchDomainUnitDto searchDomainDto = new CounterfactualSearchDomainUnitDto("integer", Boolean.TRUE, (CounterfactualDomainDto)domainCategoricalDto);
        this.mapper.writeValue((Writer)this.writer, (Object)searchDomainDto);
        String searchDomainJson = this.writer.toString();
        Assertions.assertNotNull((Object)searchDomainJson);
        CounterfactualSearchDomainDto roundTrippedSearchDomainDto = (CounterfactualSearchDomainDto)this.mapper.readValue(searchDomainJson, CounterfactualSearchDomainDto.class);
        Assertions.assertTrue((boolean)(roundTrippedSearchDomainDto instanceof CounterfactualSearchDomainUnitDto));
        CounterfactualSearchDomainUnitDto roundTrippedSearchDomainUnitDto = (CounterfactualSearchDomainUnitDto)roundTrippedSearchDomainDto;
        Assertions.assertEquals((Object)searchDomainDto.getKind(), (Object)roundTrippedSearchDomainUnitDto.getKind());
        Assertions.assertEquals((Object)searchDomainDto.getType(), (Object)roundTrippedSearchDomainUnitDto.getType());
        Assertions.assertEquals((Object)searchDomainDto.isFixed(), (Object)roundTrippedSearchDomainUnitDto.isFixed());
        Assertions.assertTrue((boolean)(roundTrippedSearchDomainUnitDto.getDomain() instanceof CounterfactualDomainCategoricalDto));
        CounterfactualDomainCategoricalDto roundTrippedDomainCategoricalDto = (CounterfactualDomainCategoricalDto)roundTrippedSearchDomainUnitDto.getDomain();
        Assertions.assertEquals((int)domainCategoricalDto.getCategories().size(), (int)roundTrippedDomainCategoricalDto.getCategories().size());
        Assertions.assertTrue((boolean)roundTrippedDomainCategoricalDto.getCategories().containsAll(domainCategoricalDto.getCategories()));
    }
}

