/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.api.ModelIdentifier;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=LIMEExplainabilityRequest.class, name="LIME"), @JsonSubTypes.Type(value=CounterfactualExplainabilityRequest.class, name="Counterfactual")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class BaseExplainabilityRequest {
    public static final String EXPLAINABILITY_TYPE_FIELD = "type";
    public static final String EXECUTION_ID_FIELD = "executionId";
    public static final String SERVICE_URL_FIELD = "serviceUrl";
    public static final String MODEL_IDENTIFIER_FIELD = "modelIdentifier";
    @JsonProperty(value="executionId")
    @NotNull(message="executionId must be provided.")
    private @NotNull(message="executionId must be provided.") String executionId;
    @JsonProperty(value="serviceUrl")
    @NotBlank(message="serviceUrl is mandatory.")
    private @NotBlank(message="serviceUrl is mandatory.") String serviceUrl;
    @JsonProperty(value="modelIdentifier")
    @NotNull(message="modelIdentifier object must be provided.")
    @Valid
    private @NotNull(message="modelIdentifier object must be provided.") @Valid ModelIdentifier modelIdentifier;

    protected BaseExplainabilityRequest() {
    }

    protected BaseExplainabilityRequest(@NotNull String executionId, @NotBlank String serviceUrl, @NotNull ModelIdentifier modelIdentifier) {
        this.executionId = Objects.requireNonNull(executionId);
        this.serviceUrl = Objects.requireNonNull(serviceUrl);
        this.modelIdentifier = Objects.requireNonNull(modelIdentifier);
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ModelIdentifier getModelIdentifier() {
        return this.modelIdentifier;
    }
}

