/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.NamedTypedValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CounterfactualExplainabilityResult
extends BaseExplainabilityResult {
    public static final String EXPLAINABILITY_TYPE_NAME = "counterfactual";
    public static final String COUNTERFACTUAL_ID_FIELD = "counterfactualId";
    public static final String COUNTERFACTUAL_SOLUTION_ID_FIELD = "solutionId";
    public static final String COUNTERFACTUAL_SEQUENCE_ID_FIELD = "sequenceId";
    public static final String IS_VALID_FIELD = "isValid";
    public static final String STAGE_FIELD = "stage";
    public static final String INPUTS_FIELD = "inputs";
    public static final String OUTPUTS_FIELD = "outputs";
    @JsonProperty(value="counterfactualId")
    @NotNull(message="counterfactualId must be provided.")
    private @NotNull(message="counterfactualId must be provided.") String counterfactualId;
    @JsonProperty(value="solutionId")
    @NotNull(message="solutionId must be provided.")
    private @NotNull(message="solutionId must be provided.") String solutionId;
    @JsonProperty(value="sequenceId")
    @NotNull(message="sequenceId must be provided.")
    private @NotNull(message="sequenceId must be provided.") Long sequenceId;
    @JsonProperty(value="isValid")
    @NotNull(message="isValid object must be provided.")
    private @NotNull(message="isValid object must be provided.") Boolean isValid;
    @JsonProperty(value="stage")
    @NotNull(message="stage object must be provided.")
    private @NotNull(message="stage object must be provided.") Stage stage;
    @JsonProperty(value="inputs")
    @NotNull(message="inputs object must be provided.")
    private @NotNull(message="inputs object must be provided.") Collection<NamedTypedValue> inputs;
    @JsonProperty(value="outputs")
    @NotNull(message="outputs object must be provided.")
    private @NotNull(message="outputs object must be provided.") Collection<NamedTypedValue> outputs;

    public CounterfactualExplainabilityResult() {
    }

    public CounterfactualExplainabilityResult(@NotNull String executionId, @NotNull String counterfactualId, @NotNull String solutionId, @NotNull Long sequenceId, @NotNull ExplainabilityStatus status, String statusDetails, @NotNull Boolean isValid, @NotNull Stage stage, @NotNull Collection<NamedTypedValue> inputs, @NotNull Collection<NamedTypedValue> outputs) {
        super(executionId, status, statusDetails);
        this.counterfactualId = Objects.requireNonNull(counterfactualId);
        this.solutionId = Objects.requireNonNull(solutionId);
        this.sequenceId = Objects.requireNonNull(sequenceId);
        this.isValid = Objects.requireNonNull(isValid);
        this.stage = Objects.requireNonNull(stage);
        this.inputs = Objects.requireNonNull(inputs);
        this.outputs = Objects.requireNonNull(outputs);
    }

    public static CounterfactualExplainabilityResult buildSucceeded(String executionId, String counterfactualId, String solutionId, Long sequenceId, Boolean isValid, Stage stage, Collection<NamedTypedValue> inputs, Collection<NamedTypedValue> outputs) {
        return new CounterfactualExplainabilityResult(executionId, counterfactualId, solutionId, sequenceId, ExplainabilityStatus.SUCCEEDED, null, isValid, stage, inputs, outputs);
    }

    public static CounterfactualExplainabilityResult buildFailed(String executionId, String counterfactualId, String statusDetails) {
        return new CounterfactualExplainabilityResult(executionId, counterfactualId, UUID.randomUUID().toString(), Long.MAX_VALUE, ExplainabilityStatus.FAILED, statusDetails, Boolean.FALSE, Stage.FINAL, Collections.emptyList(), Collections.emptyList());
    }

    public String getCounterfactualId() {
        return this.counterfactualId;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public Long getSequenceId() {
        return this.sequenceId;
    }

    public Boolean isValid() {
        return this.isValid;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Collection<NamedTypedValue> getInputs() {
        return this.inputs;
    }

    public Collection<NamedTypedValue> getOutputs() {
        return this.outputs;
    }

    public static enum Stage {
        INTERMEDIATE,
        FINAL;

    }
}

