/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

class TypeTest {
    TypeTest() {
    }

    @Test
    void testPerturbNumericDouble() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)0.1);
        Feature f = new Feature("name", Type.NUMBER, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbNumericInteger() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)1);
        Feature f = new Feature("name", Type.NUMBER, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbSingleTermString() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"foo");
        Feature f = new Feature("name", Type.TEXT, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbMultiTermString() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"foo bar");
        Feature f = new Feature("name", Type.TEXT, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbCategorical() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"1");
        Feature f = new Feature("name", Type.CATEGORICAL, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbBinary() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        ByteBuffer bytes = ByteBuffer.allocate(16);
        bytes.put("foo".getBytes(Charset.defaultCharset()));
        Value value = new Value((Object)bytes);
        Feature f = new Feature("name", Type.BINARY, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbBoolean() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)false);
        Feature f = new Feature("name", Type.BOOLEAN, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbDuration() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)Duration.ofDays(10L));
        Feature f = new Feature("name", Type.DURATION, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbTime() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)LocalTime.of(10, 10));
        Feature f = new Feature("name", Type.TIME, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbURI() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Value value = new Value((Object)"http://localhost:8080");
        Feature f = new Feature("name", Type.URI, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbVector() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        double[] doubles = new double[3];
        Arrays.fill(doubles, 1.0);
        Value value = new Value((Object)doubles);
        Feature f = new Feature("name", Type.VECTOR, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbNestedFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1);
        Feature feature = new Feature("name", Type.NUMBER, new Value((Object)1.0));
        Value value = new Value((Object)feature);
        Feature f = new Feature("name", Type.UNDEFINED, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbCompositeFeature() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 2);
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(new Feature("f1", Type.TEXT, new Value((Object)"foo bar")));
        features.add(new Feature("f2", Type.NUMBER, new Value((Object)1.0)));
        features.add(new Feature("f3", Type.BOOLEAN, new Value((Object)true)));
        Value value = new Value(features);
        Feature f = new Feature("name", Type.COMPOSITE, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @Test
    void testPerturbCompositeFeatureTooManyPerturbations() {
        PerturbationContext perturbationContext = new PerturbationContext(new Random(), 1000);
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(new Feature("f1", Type.TEXT, new Value((Object)"foo bar")));
        features.add(new Feature("f2", Type.NUMBER, new Value((Object)1.0)));
        Value value = new Value(features);
        Feature f = new Feature("name", Type.COMPOSITE, value);
        Value perturbedValue = f.getType().perturb(f.getValue(), perturbationContext);
        Assertions.assertNotEquals((Object)value, (Object)perturbedValue);
    }

    @ParameterizedTest
    @EnumSource
    void testDrop(Type type) {
        Value v = new Value((Object)1.0);
        Value dropped = type.drop(v);
        Assertions.assertNotEquals((Object)v, (Object)dropped);
    }

    @ParameterizedTest
    @EnumSource
    void testPerturb(Type type) {
        for (int seed = 0; seed < 5; ++seed) {
            Value v = new Value((Object)1.0);
            Random random = new Random();
            random.setSeed(seed);
            PerturbationContext perturbationContext = new PerturbationContext(random, 1);
            Value perturbed = type.perturb(v, perturbationContext);
            Assertions.assertNotEquals((Object)v, (Object)perturbed, (String)type.name());
        }
    }
}

