/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.model.Value;

class ValueTest {
    ValueTest() {
    }

    @Test
    void testStringValue() {
        Value stringValue = new Value((Object)"foo bar");
        Assertions.assertNotNull((Object)stringValue.getUnderlyingObject());
        Assertions.assertEquals((Object)"foo bar", (Object)stringValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)stringValue.asString());
        Assertions.assertEquals((Object)"foo bar", (Object)stringValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)stringValue.asNumber());
        double[] vector = stringValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 1.0}, (double[])vector);
    }

    @Test
    void testNumericValue() {
        Value numericValue = new Value((Object)1.1);
        Assertions.assertNotNull((Object)numericValue.getUnderlyingObject());
        Assertions.assertEquals((double)1.1, (Double)((Double)numericValue.getUnderlyingObject()));
        Assertions.assertNotNull((Object)numericValue.asString());
        Assertions.assertEquals((Object)"1.1", (Object)numericValue.asString());
        Assertions.assertEquals((double)1.1, (double)numericValue.asNumber());
        double[] vector = numericValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])new double[]{1.1}, (double[])vector);
    }

    @Test
    void testVectorValue() {
        double[] doubles = new double[]{0.1, 0.2, 0.3};
        Value vectorValue = new Value((Object)doubles);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)doubles, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)"{0.1,0.2,0.3}", (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])doubles, (double[])vector);
    }

    @Test
    void testStringVectorValue() {
        String vectorString = "0.1 0.2 0.3";
        Value vectorValue = new Value((Object)vectorString);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])new double[]{0.1, 0.2, 0.3}, (double[])vector);
    }

    @Test
    void testStringVectorValueWithCommas() {
        String vectorString = "0.1, 0.2, 0.3";
        Value vectorValue = new Value((Object)vectorString);
        Assertions.assertNotNull((Object)vectorValue.getUnderlyingObject());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.getUnderlyingObject());
        Assertions.assertNotNull((Object)vectorValue.asString());
        Assertions.assertEquals((Object)vectorString, (Object)vectorValue.asString());
        Assertions.assertEquals((double)Double.NaN, (double)vectorValue.asNumber());
        double[] vector = vectorValue.asVector();
        Assertions.assertNotNull((Object)vector);
        Assertions.assertArrayEquals((double[])new double[]{0.1, 0.2, 0.3}, (double[])vector);
    }
}

