/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;

class FeatureFactoryTest {
    FeatureFactoryTest() {
    }

    private void assertFeature(Type type, Object object, Feature feature) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)feature);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)feature.getName());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)feature.getType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)type, (Object)feature.getType());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)feature.getValue());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)feature.getValue().getUnderlyingObject());
        if (Type.COMPOSITE.equals((Object)type)) {
            Collection objectCollection = (Collection)object;
            Collection featureCollection = (Collection)feature.getValue().getUnderlyingObject();
            for (Feature f : objectCollection) {
                Assertions.assertThat((Object)f).isIn((Iterable)featureCollection);
            }
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)object, (Object)feature.getValue().getUnderlyingObject());
        }
    }

    @Test
    void testTimeFeature() {
        LocalTime time = LocalTime.now();
        String name = "some-name";
        Feature feature = FeatureFactory.newTimeFeature((String)name, (LocalTime)time);
        this.assertFeature(Type.TIME, time, feature);
    }

    @Test
    void testCategoricalFeature() {
        String name = "some-name";
        String category = "FIXED-CAT";
        Feature feature = FeatureFactory.newCategoricalFeature((String)name, (String)category);
        this.assertFeature(Type.CATEGORICAL, category, feature);
    }

    @Test
    void testNumberFeature() {
        String name = "some-name";
        Double number = 0.1;
        Feature feature = FeatureFactory.newNumericalFeature((String)name, (Number)number);
        this.assertFeature(Type.NUMBER, number, feature);
    }

    @Test
    void testBooleanFeature() {
        String name = "some-name";
        Feature feature = FeatureFactory.newBooleanFeature((String)name, (Boolean)false);
        this.assertFeature(Type.BOOLEAN, false, feature);
    }

    @Test
    void testCurrencyFeature() {
        String name = "some-name";
        Currency currency = Currency.getInstance(Locale.getDefault());
        Feature feature = FeatureFactory.newCurrencyFeature((String)name, (Currency)currency);
        this.assertFeature(Type.CURRENCY, currency, feature);
    }

    @Test
    void testBinaryFeature() {
        String name = "some-name";
        ByteBuffer binary = ByteBuffer.allocate(256);
        Feature feature = FeatureFactory.newBinaryFeature((String)name, (ByteBuffer)binary);
        this.assertFeature(Type.BINARY, binary, feature);
    }

    @Test
    void testURIFeature() {
        String name = "some-name";
        URI uri = URI.create("./");
        Feature feature = FeatureFactory.newURIFeature((String)name, (URI)uri);
        this.assertFeature(Type.URI, uri, feature);
    }

    @Test
    void testDurationFeature() {
        String name = "some-name";
        Duration duration = Duration.ofDays(1L);
        Feature feature = FeatureFactory.newDurationFeature((String)name, (Duration)duration);
        this.assertFeature(Type.DURATION, duration, feature);
    }

    @Test
    void testTextFeature() {
        String name = "some-name";
        String text = "some text value";
        Feature feature = FeatureFactory.newTextFeature((String)name, (String)text);
        this.assertFeature(Type.TEXT, text, feature);
    }

    @Test
    void testVectorFeature() {
        String name = "some-name";
        double[] vector = new double[10];
        Arrays.fill(vector, 1.0);
        Feature feature = FeatureFactory.newVectorFeature((String)name, (double[])vector);
        this.assertFeature(Type.VECTOR, vector, feature);
    }

    @Test
    void testObjectFeature() {
        String name = "some-name";
        Object object = new Object();
        Feature feature = FeatureFactory.newObjectFeature((String)name, (Object)object);
        this.assertFeature(Type.UNDEFINED, object, feature);
    }

    @Test
    void testNestedCompositeFeature() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newObjectFeature((String)"f1", (Object)new Object()));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)"hola"));
        features.add(FeatureFactory.newFulltextFeature((String)"f3", (String)"foo bar"));
        features.add(FeatureFactory.newNumericalFeature((String)"f4", (Number)131));
        features.add(FeatureFactory.newBooleanFeature((String)"f5", (Boolean)false));
        features.add(FeatureFactory.newDurationFeature((String)"f6", (Duration)Duration.ofDays(2L)));
        HashMap<String, Object> nestedMap = new HashMap<String, Object>();
        nestedMap.put("nf-1", "nested text");
        nestedMap.put("nf-2", ByteBuffer.allocate(1024));
        features.add(FeatureFactory.newCompositeFeature((String)"f7", nestedMap));
        for (Feature f : features) {
            map.put(f.getName(), f.getValue().getUnderlyingObject());
        }
        String name = "some-name";
        Feature feature = FeatureFactory.newCompositeFeature((String)name, map);
        this.assertFeature(Type.COMPOSITE, features, feature);
    }

    @Test
    void testCopySame() {
        for (Type type : Type.values()) {
            Value v = new Value((Object)"1");
            Feature feature = new Feature("name", type, v);
            Feature copy = FeatureFactory.copyOf((Feature)feature, (Value)v);
            org.junit.jupiter.api.Assertions.assertEquals((Object)feature, (Object)copy);
        }
    }

    @Test
    void testCopyDifferent() {
        for (Type type : Type.values()) {
            Value v = new Value((Object)"1");
            Feature feature = new Feature("name", type, v);
            Feature copy = FeatureFactory.copyOf((Feature)feature, (Value)new Value((Object)"2"));
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)feature, (Object)copy);
        }
    }
}

