/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.time.Duration;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

class DataUtilsTest {
    private static final Random random = new Random();

    DataUtilsTest() {
    }

    @BeforeAll
    static void setupBefore() {
        random.setSeed(4L);
    }

    @Test
    void testDataGeneration() {
        double mean = 0.5;
        double stdDeviation = 0.1;
        int size = 100;
        double[] data = DataUtils.generateData((double)mean, (double)stdDeviation, (int)size, (Random)random);
        org.junit.jupiter.api.Assertions.assertEquals((double)mean, (double)DataUtils.getMean((double[])data), (double)0.01);
        org.junit.jupiter.api.Assertions.assertEquals((double)stdDeviation, (double)DataUtils.getStdDev((double[])data, (double)mean), (double)0.01);
        double sum = 0.0;
        for (double d : data) {
            sum += d - mean;
        }
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)sum, (double)1.0E-4);
    }

    @Test
    void testGetMean() {
        double[] data = new double[]{2.0, 4.0, 3.0, 5.0, 1.0};
        org.junit.jupiter.api.Assertions.assertEquals((double)3.0, (double)DataUtils.getMean((double[])data), (double)1.0E-6);
    }

    @Test
    void testGetStdDev() {
        double[] data = new double[]{2.0, 4.0, 3.0, 5.0, 1.0};
        org.junit.jupiter.api.Assertions.assertEquals((double)1.41, (double)DataUtils.getStdDev((double[])data, (double)3.0), (double)0.01);
    }

    @Test
    void testGaussianKernel() {
        double x = 0.218;
        double k = DataUtils.gaussianKernel((double)x, (double)0.0, (double)1.0);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.389, (double)k, (double)0.001);
    }

    @Test
    void testEuclideanDistance() {
        double[] x = new double[]{1.0, 1.0};
        double[] y = new double[]{2.0, 3.0};
        double distance = DataUtils.euclideanDistance((double[])x, (double[])y);
        org.junit.jupiter.api.Assertions.assertEquals((double)2.236, (double)distance, (double)0.001);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(DataUtils.euclideanDistance((double[])x, (double[])new double[0])));
    }

    @Test
    void testHammingDistanceDouble() {
        double[] x = new double[]{2.0, 1.0};
        double[] y = new double[]{2.0, 3.0};
        double distance = DataUtils.hammingDistance((double[])x, (double[])y);
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)distance, (double)0.1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(DataUtils.hammingDistance((double[])x, (double[])new double[0])));
    }

    @Test
    void testHammingDistanceString() {
        String x = "test1";
        String y = "test2";
        double distance = DataUtils.hammingDistance((String)x, (String)y);
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)distance, (double)0.1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Double.isNaN(DataUtils.hammingDistance((String)x, (String)"testTooLong")));
    }

    @Test
    void testExponentialSmoothingKernel() {
        double x = 0.218;
        double k = DataUtils.exponentialSmoothingKernel((double)x, (double)2.0);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.994, (double)k, (double)0.001);
    }

    @Test
    void testPerturbFeaturesEmpty() {
        LinkedList features = new LinkedList();
        PerturbationContext perturbationContext = new PerturbationContext(random, 0);
        List newFeatures = DataUtils.perturbFeatures(features, (PerturbationContext)perturbationContext);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)newFeatures);
        org.junit.jupiter.api.Assertions.assertEquals((int)features.size(), (int)newFeatures.size());
    }

    @Test
    void testPerturbDropNumericZero() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newNumericalFeature((String)"f0", (Number)1));
        features.add(FeatureFactory.newNumericalFeature((String)"f1", (Number)3.14));
        features.add(FeatureFactory.newNumericalFeature((String)"f2", (Number)5));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropNumeric(input, 0);
    }

    @Test
    void testPerturbDropNumericOne() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newNumericalFeature((String)"f0", (Number)1));
        features.add(FeatureFactory.newNumericalFeature((String)"f1", (Number)3.14));
        features.add(FeatureFactory.newNumericalFeature((String)"f2", (Number)0.55));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropNumeric(input, 1);
    }

    @Test
    void testPerturbDropNumericTwo() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newNumericalFeature((String)"f0", (Number)1));
        features.add(FeatureFactory.newNumericalFeature((String)"f1", (Number)3.14));
        features.add(FeatureFactory.newNumericalFeature((String)"f2", (Number)0.55));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropNumeric(input, 2);
    }

    @Test
    void testPerturbDropNumericThree() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newNumericalFeature((String)"f0", (Number)1));
        features.add(FeatureFactory.newNumericalFeature((String)"f1", (Number)3.14));
        features.add(FeatureFactory.newNumericalFeature((String)"f2", (Number)0.55));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropNumeric(input, 3);
    }

    @Test
    void testPerturbDropStringZero() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropString(input, 0);
    }

    @Test
    void testPerturbDropStringOne() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropString(input, 1);
    }

    @Test
    void testPerturbDropStringTwo() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropString(input, 2);
    }

    @Test
    void testPerturbDropStringThree() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(features);
        this.assertPerturbDropString(input, 3);
    }

    @Test
    void testPerturbDropCompositeStringZero() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(List.of(FeatureFactory.newCompositeFeature((String)"composite", features)));
        this.assertPerturbDropString(input, 0);
    }

    @Test
    void testPerturbDropCompositeStringOne() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(List.of(FeatureFactory.newCompositeFeature((String)"composite", features)));
        this.assertPerturbDropString(input, 1);
    }

    @Test
    void testPerturbDropCompositeStringTwo() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(List.of(FeatureFactory.newCompositeFeature((String)"composite", features)));
        this.assertPerturbDropString(input, 2);
    }

    @Test
    void testPerturbDropCompositeStringThree() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo"));
        features.add(FeatureFactory.newTextFeature((String)"f1", (String)"foo bar"));
        features.add(FeatureFactory.newTextFeature((String)"f2", (String)" "));
        features.add(FeatureFactory.newTextFeature((String)"f3", (String)"foo bar "));
        PredictionInput input = new PredictionInput(List.of(FeatureFactory.newCompositeFeature((String)"composite", features)));
        this.assertPerturbDropString(input, 3);
    }

    private void assertPerturbDropNumeric(PredictionInput input, int noOfPerturbations) {
        List newFeatures = DataUtils.perturbFeatures((List)input.getFeatures(), (PerturbationContext)new PerturbationContext(random, noOfPerturbations));
        int changedFeatures = 0;
        for (int i = 0; i < input.getFeatures().size(); ++i) {
            double pv;
            double v = ((Feature)input.getFeatures().get(i)).getValue().asNumber();
            if (v == (pv = ((Feature)newFeatures.get(i)).getValue().asNumber())) continue;
            ++changedFeatures;
        }
        Assertions.assertThat((int)changedFeatures).isBetween(Integer.valueOf((int)Math.min((double)noOfPerturbations, (double)input.getFeatures().size() * 0.5)), Integer.valueOf((int)Math.max((double)noOfPerturbations, (double)input.getFeatures().size() * 0.5)));
    }

    private void assertPerturbDropString(PredictionInput input, int noOfPerturbations) {
        List newFeatures = DataUtils.perturbFeatures((List)input.getFeatures(), (PerturbationContext)new PerturbationContext(random, noOfPerturbations));
        int changedFeatures = 0;
        for (int i = 0; i < input.getFeatures().size(); ++i) {
            String pv;
            String v = ((Feature)input.getFeatures().get(i)).getValue().asString();
            if (v.equals(pv = ((Feature)newFeatures.get(i)).getValue().asString())) continue;
            ++changedFeatures;
        }
        Assertions.assertThat((int)changedFeatures).isBetween(Integer.valueOf((int)Math.min((double)noOfPerturbations, (double)input.getFeatures().size() * 0.5)), Integer.valueOf((int)Math.max((double)noOfPerturbations, (double)input.getFeatures().size() * 0.5)));
    }

    @Test
    void testDoublesToFeatures() {
        double[] inputs = new double[10];
        for (int i = 0; i < 10; ++i) {
            inputs[i] = i % 2 == 0 ? 1.0 : 0.0;
        }
        List features = DataUtils.doublesToFeatures((double[])inputs);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)features);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)features.size());
        for (Feature f : features) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)f);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)f.getName());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Type.NUMBER, (Object)f.getType());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)f.getValue());
        }
    }

    @Test
    void testDoubleToFeature() {
        double d = 0.5;
        Feature f = DataUtils.doubleToFeature((double)d);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)f);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)f.getName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Type.NUMBER, (Object)f.getType());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)f.getValue());
    }

    @Test
    void testRandomDistributionGeneration() {
        DataDistribution dataDistribution = DataUtils.generateRandomDataDistribution((int)10, (int)10, (Random)random);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)dataDistribution);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)dataDistribution.getFeatureDistributions());
        for (FeatureDistribution featureDistribution : dataDistribution.getFeatureDistributions()) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)featureDistribution);
        }
    }

    @Test
    void testGetFeatureDistribution() {
        double[] doubles = new double[10];
        Arrays.fill(doubles, 1.0);
        FeatureDistribution featureDistribution = DataUtils.getFeatureDistribution((double[])doubles);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)featureDistribution);
    }

    @Test
    void testLinearizedNumericFeatures() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        Feature f = TestUtils.getMockedNumericFeature();
        features.add(f);
        List linearizedFeatures = DataUtils.getLinearizedFeatures(features);
        org.junit.jupiter.api.Assertions.assertEquals((int)features.size(), (int)linearizedFeatures.size());
    }

    @Test
    void testLinearizedTextFeatures() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        Feature f = TestUtils.getMockedTextFeature("foo bar ");
        features.add(f);
        List linearizedFeatures = DataUtils.getLinearizedFeatures(features);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)linearizedFeatures.size());
    }

    @Test
    void testCompositeLinearizedFeatures() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        LinkedList<Feature> list = new LinkedList<Feature>();
        list.add(FeatureFactory.newTextFeature((String)"f0", (String)"foo bar"));
        list.add(FeatureFactory.newFulltextFeature((String)"f0", (String)"foo bar", s -> Arrays.asList(s.split(" "))));
        list.add(FeatureFactory.newCategoricalFeature((String)"f0", (String)"1"));
        list.add(FeatureFactory.newBooleanFeature((String)"f1", (Boolean)true));
        list.add(FeatureFactory.newNumericalFeature((String)"f2", (Number)13));
        list.add(FeatureFactory.newDurationFeature((String)"f3", (Duration)Duration.ofDays(13L)));
        list.add(FeatureFactory.newTimeFeature((String)"f4", (LocalTime)LocalTime.now()));
        list.add(FeatureFactory.newObjectFeature((String)"f5", (Object)new float[]{0.4f, 0.4f}));
        list.add(FeatureFactory.newObjectFeature((String)"f6", (Object)FeatureFactory.newObjectFeature((String)"nf-0", (Object)new Object())));
        Feature f = FeatureFactory.newCompositeFeature((String)"name", list);
        features.add(f);
        List linearizedFeatures = DataUtils.getLinearizedFeatures(features);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)linearizedFeatures.size());
    }

    @Test
    void testDropFeature() {
        for (Type t : Type.values()) {
            Feature target = TestUtils.getMockedFeature(t, new Value((Object)1.0));
            LinkedList<Feature> features = new LinkedList<Feature>();
            features.add(TestUtils.getMockedNumericFeature());
            features.add(target);
            features.add(TestUtils.getMockedTextFeature("foo bar"));
            features.add(TestUtils.getMockedNumericFeature());
            List newFeatures = DataUtils.dropFeature(features, (Feature)target);
            org.junit.jupiter.api.Assertions.assertNotEquals(features, (Object)newFeatures);
        }
    }

    @Test
    void testDropLinearizedFeature() {
        for (Type t : Type.values()) {
            Feature target = TestUtils.getMockedFeature(t, new Value((Object)1.0));
            LinkedList<Feature> features = new LinkedList<Feature>();
            features.add(TestUtils.getMockedNumericFeature());
            features.add(target);
            features.add(TestUtils.getMockedTextFeature("foo bar"));
            features.add(TestUtils.getMockedNumericFeature());
            Feature source = FeatureFactory.newCompositeFeature((String)"composite", features);
            Feature newFeature = DataUtils.dropOnLinearizedFeatures((Feature)target, (Feature)source);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)source, (Object)newFeature);
        }
    }
}

