package org.kie.kogito.explainability.model;

/**
 * Metadata about a given {@link PredictionProvider}.
 */
public interface PredictionProviderMetadata {

    /**
     * Fetch the data distribution associated to this model
     *
     * @return the data distribution
     */
    DataDistribution getDataDistribution();

    /**
     * get the shape of inputs expected by this model
     *
     * @return a synthetic prediction input (with fake or null values)
     */
    PredictionInput getInputShape();

    /**
     * get the shape of prediction outputs generated by this model
     *
     * @return a synthetic prediction output (with fake or null values)
     */
    PredictionOutput getOutputShape();
}
