/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime.optim;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.optim.LimeConfigOptimizer;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.utils.DataUtils;

class LimeConfigOptimizerTest {
    LimeConfigOptimizerTest() {
    }

    @Test
    void testImpactOptimization() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forImpactScore();
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testImpactOptimizationNoSampling() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forImpactScore().withSampling(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testImpactOptimizationNoWeighting() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forImpactScore().withWeighting(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testImpactOptimizationNoEncoding() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forImpactScore().withEncoding(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testImpactOptimizationNoProximity() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forImpactScore().withProximity(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testImpactOptimizationNoEntity() {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forImpactScore().withSampling(false).withEncoding(false).withWeighting(false).withProximity(false);
        org.junit.jupiter.api.Assertions.assertThrows(AssertionError.class, () -> this.assertConfigOptimized(limeConfigOptimizer));
    }

    @Test
    void testStabilityOptimization() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forStabilityScore();
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testStabilityOptimizationNoSampling() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forStabilityScore().withSampling(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testStabilityOptimizationNoWeighting() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forStabilityScore().withWeighting(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testStabilityOptimizationNoEncoding() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forStabilityScore().withEncoding(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testStabilityOptimizationNoProximity() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forStabilityScore().withProximity(false);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testStabilityOptimizationNoEntity() {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().forStabilityScore().withSampling(false).withEncoding(false).withWeighting(false).withProximity(false);
        org.junit.jupiter.api.Assertions.assertThrows(AssertionError.class, () -> this.assertConfigOptimized(limeConfigOptimizer));
    }

    @Test
    void testWeightedStabilityOptimization() throws Exception {
        LimeConfigOptimizer limeConfigOptimizer = new LimeConfigOptimizer().withWeightedStability(0.5, 0.5);
        this.assertConfigOptimized(limeConfigOptimizer);
        limeConfigOptimizer = new LimeConfigOptimizer().withWeightedStability(0.3, 0.7);
        this.assertConfigOptimized(limeConfigOptimizer);
        limeConfigOptimizer = new LimeConfigOptimizer().withWeightedStability(0.7, 0.3);
        this.assertConfigOptimized(limeConfigOptimizer);
        limeConfigOptimizer = new LimeConfigOptimizer().withWeightedStability(1.0, 0.0);
        this.assertConfigOptimized(limeConfigOptimizer);
        limeConfigOptimizer = new LimeConfigOptimizer().withWeightedStability(0.0, 1.0);
        this.assertConfigOptimized(limeConfigOptimizer);
    }

    @Test
    void testWeightedStabilityWrongParamsOptimization() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(0.8, 0.7));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(0.1, 0.7));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(0.1, 1.1));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(2.1, 0.1));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(-0.1, 0.9));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(0.1, -0.9));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(0.1, 0.99));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> new LimeConfigOptimizer().withWeightedStability(0.009, 0.99));
    }

    private void assertConfigOptimized(LimeConfigOptimizer limeConfigOptimizer) throws InterruptedException, ExecutionException {
        PredictionProvider model = TestUtils.getSumSkipModel(1);
        Random random = new Random();
        random.setSeed(4L);
        DataDistribution dataDistribution = DataUtils.generateRandomDataDistribution((int)5, (int)100, (Random)random);
        List samples = dataDistribution.sample(10);
        List predictionOutputs = (List)model.predictAsync(samples).get();
        List predictions = DataUtils.getPredictions((List)samples, (List)predictionOutputs);
        LimeConfig initialConfig = new LimeConfig().withSamples(10);
        LimeConfig optimizedConfig = limeConfigOptimizer.optimize(initialConfig, predictions, model);
        AssertionsForClassTypes.assertThat((Object)optimizedConfig).isNotNull();
        Assertions.assertThat((Object)optimizedConfig).isNotSameAs((Object)initialConfig);
    }
}

