/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.shap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.local.shap.ShapConfig;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.utils.MatrixUtils;

class ShapConfigTest {
    PerturbationContext pc = new PerturbationContext(new Random(), 0);
    List<Feature> fs = Arrays.asList(FeatureFactory.newNumericalFeature((String)"f", (Number)1.0), FeatureFactory.newNumericalFeature((String)"f", (Number)2.0));
    PredictionInput pi = new PredictionInput(this.fs);
    List<PredictionInput> pis = Arrays.asList(this.pi, this.pi);
    List<PredictionInput> piEmpty = new ArrayList<PredictionInput>();
    double[][] piMatrix = MatrixUtils.matrixFromPredictionInput(this.pis);

    ShapConfigTest() {
    }

    @Test
    void testRecovery() {
        ForkJoinPool executor = ForkJoinPool.commonPool();
        ShapConfig skConfig = ShapConfig.builder().withLink(ShapConfig.LinkType.IDENTITY).withBackground(this.pis).withPC(this.pc).withExecutor((Executor)executor).withNSamples(Integer.valueOf(100)).withConfidence(0.99).build();
        Assertions.assertEquals((Object)ShapConfig.LinkType.IDENTITY, (Object)skConfig.getLink());
        Assertions.assertTrue((boolean)skConfig.getNSamples().isPresent());
        Assertions.assertEquals((int)100, (Integer)((Integer)skConfig.getNSamples().get()));
        Assertions.assertEquals((double)0.99, (double)skConfig.getConfidence());
        Assertions.assertSame((Object)this.pc, (Object)skConfig.getPC());
        Assertions.assertSame((Object)executor, (Object)skConfig.getExecutor());
        Assertions.assertSame(this.pis, (Object)skConfig.getBackground());
        Assertions.assertTrue((boolean)Arrays.deepEquals((Object[])this.piMatrix, (Object[])skConfig.getBackgroundMatrix()));
    }

    @Test
    void testNullRecovery() {
        ShapConfig skConfig = ShapConfig.builder().withLink(ShapConfig.LinkType.LOGIT).withBackground(this.pis).build();
        Assertions.assertEquals((Object)ShapConfig.LinkType.LOGIT, (Object)skConfig.getLink());
        Assertions.assertFalse((boolean)skConfig.getNSamples().isPresent());
        Assertions.assertSame(this.pis, (Object)skConfig.getBackground());
        Assertions.assertTrue((boolean)Arrays.deepEquals((Object[])this.piMatrix, (Object[])skConfig.getBackgroundMatrix()));
        Assertions.assertSame((Object)ForkJoinPool.commonPool(), (Object)skConfig.getExecutor());
        Assertions.assertFalse((boolean)skConfig.getNSamples().isPresent());
    }

    @Test
    void testMandatoryErrors() {
        ShapConfig.Builder linkNoBG = ShapConfig.builder().withLink(ShapConfig.LinkType.IDENTITY);
        ShapConfig.Builder bgNoLink = ShapConfig.builder().withBackground(this.pis);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ShapConfig.Builder)linkNoBG).build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ShapConfig.Builder)bgNoLink).build());
    }

    @Test
    void testEmptyBackgroundMandatoryErrors() {
        ShapConfig.Builder emptyBG = ShapConfig.builder().withLink(ShapConfig.LinkType.IDENTITY).withBackground(this.piEmpty);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ShapConfig.Builder)emptyBG).build());
    }
}

