/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;

class FeatureDomainTest {
    FeatureDomainTest() {
    }

    @Test
    void getCategories() {
        FeatureDomain domain = CategoricalFeatureDomain.create((String[])new String[]{"foo", "bar", "foo", "bar", "bar"});
        Assertions.assertEquals(Set.of("foo", "bar"), (Object)domain.getCategories());
    }

    @Test
    void isEmpty() {
        FeatureDomain domain = EmptyFeatureDomain.create();
        Assertions.assertNull((Object)domain.getCategories());
        Assertions.assertNull((Object)domain.getLowerBound());
        Assertions.assertNull((Object)domain.getUpperBound());
        Assertions.assertTrue((boolean)domain.isEmpty());
    }

    @Test
    void getStart() {
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        Assertions.assertEquals((double)0.0, (Double)domain.getLowerBound());
    }

    @Test
    void getEnd() {
        FeatureDomain domain = NumericalFeatureDomain.create((double)-10.0, (double)-5.0);
        Assertions.assertEquals((double)-5.0, (Double)domain.getUpperBound());
    }
}

