/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;

@PlanningSolution
public class CounterfactualSolution {
    private List<CounterfactualEntity> entities;
    private List<Output> goal;
    private PredictionProvider model;
    private BendableBigDecimalScore score;
    private UUID solutionId;
    private UUID executionId;
    private List<PredictionOutput> predictionOutputs;

    @PlanningEntityCollectionProperty
    public List<CounterfactualEntity> getVaryingEntities() {
        return this.entities.stream().filter(counterfactualEntity -> !counterfactualEntity.isConstrained()).collect(Collectors.toList());
    }

    protected CounterfactualSolution() {
    }

    public CounterfactualSolution(List<CounterfactualEntity> entities, PredictionProvider model, List<Output> goal, UUID solutionId, UUID executionId) {
        this.entities = entities;
        this.model = model;
        this.goal = goal;
        this.solutionId = solutionId;
        this.executionId = executionId;
    }

    @PlanningScore(bendableHardLevelsSize=3, bendableSoftLevelsSize=2)
    public BendableBigDecimalScore getScore() {
        return this.score;
    }

    public void setScore(BendableBigDecimalScore score) {
        this.score = score;
    }

    public PredictionProvider getModel() {
        return this.model;
    }

    public List<Output> getGoal() {
        return this.goal;
    }

    public List<CounterfactualEntity> getEntities() {
        return this.entities;
    }

    public void setSolutionId(UUID solutionId) {
        this.solutionId = solutionId;
    }

    public UUID getSolutionId() {
        return this.solutionId;
    }

    public UUID getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(UUID executionId) {
        this.executionId = executionId;
    }

    public List<PredictionOutput> getPredictionOutputs() {
        return this.predictionOutputs;
    }

    public void setPredictionOutputs(List<PredictionOutput> predictionOutputs) {
        this.predictionOutputs = predictionOutputs;
    }
}

