/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Value;

public class IndependentFeaturesDataDistribution
implements DataDistribution {
    private final List<FeatureDistribution> featureDistributions;

    public IndependentFeaturesDataDistribution(List<FeatureDistribution> featureDistributions) {
        this.featureDistributions = Collections.unmodifiableList(featureDistributions);
    }

    @Override
    public PredictionInput sample() {
        ArrayList<Feature> features = new ArrayList<Feature>(this.featureDistributions.size());
        for (FeatureDistribution featureDistribution : this.featureDistributions) {
            Feature feature = featureDistribution.getFeature();
            features.add(FeatureFactory.copyOf(feature, featureDistribution.sample()));
        }
        return new PredictionInput(features);
    }

    @Override
    public List<PredictionInput> sample(int sampleSize) {
        ArrayList<PredictionInput> inputs = new ArrayList<PredictionInput>(sampleSize);
        for (int i = 0; i < sampleSize; ++i) {
            inputs.add(this.sample());
        }
        return inputs;
    }

    @Override
    public List<PredictionInput> getAllSamples() {
        ArrayList featureEnumerations = new ArrayList(this.featureDistributions.size());
        for (FeatureDistribution featureDistribution : this.featureDistributions) {
            List<Value> allValues = featureDistribution.getAllSamples();
            ArrayList<Feature> arrayList = new ArrayList<Feature>(allValues.size());
            Feature feature = featureDistribution.getFeature();
            for (Value v : allValues) {
                Feature f = FeatureFactory.copyOf(feature, v);
                arrayList.add(f);
            }
            featureEnumerations.add(arrayList);
        }
        Collection combinedFeaturesList = IndependentFeaturesDataDistribution.cartesianProduct(featureEnumerations);
        ArrayList<PredictionInput> inputs = new ArrayList<PredictionInput>(combinedFeaturesList.size());
        for (List<Feature> list : combinedFeaturesList) {
            inputs.add(new PredictionInput(list));
        }
        return inputs;
    }

    static <T> Collection<List<T>> cartesianProduct(List<Collection<T>> valueEnumerations) {
        ArrayList<List<T>> combinedValues = new ArrayList<List<T>>();
        if (!valueEnumerations.isEmpty()) {
            IndependentFeaturesDataDistribution.getElementsAtDepth(valueEnumerations, combinedValues, 0, new ArrayList());
        }
        return combinedValues;
    }

    private static <T> void getElementsAtDepth(List<Collection<T>> valueEnumerations, Collection<List<T>> combinedValues, int depth, List<T> currentItem) {
        if (depth == valueEnumerations.size()) {
            combinedValues.add(currentItem);
        } else {
            Collection<T> currentCollection = valueEnumerations.get(depth);
            for (T element : currentCollection) {
                ArrayList<T> copy = new ArrayList<T>(currentItem);
                copy.add(element);
                IndependentFeaturesDataDistribution.getElementsAtDepth(valueEnumerations, combinedValues, depth + 1, copy);
            }
        }
    }

    @Override
    public List<FeatureDistribution> asFeatureDistributions() {
        return this.featureDistributions;
    }
}

