/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.counterfactual.CounterFactualScoreCalculator;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualSolution;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionFeatureDomain;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;

class CounterfactualScoreCalculatorTest {
    CounterfactualScoreCalculatorTest() {
    }

    private static Output outputFromFeature(Feature feature) {
        return new Output(feature.getName(), feature.getType(), feature.getValue(), 0.0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceSameValue(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt();
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceSameValueZero(int seed) {
        Random random = new Random(seed);
        boolean value = false;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)Math.abs(distance));
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceSameValue(int seed) {
        Random random = new Random(seed);
        double value = random.nextDouble();
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceSameValueZero(int seed) {
        Random random = new Random(seed);
        double value = 0.0;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)0.0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)0.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void BooleanDistanceSameValue(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        Feature x = FeatureFactory.newBooleanFeature((String)"x", (Boolean)value);
        Feature y = FeatureFactory.newBooleanFeature((String)"y", (Boolean)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void CategoricalDistanceSameValue(int seed) {
        Random random = new Random(seed);
        String value = UUID.randomUUID().toString();
        Feature x = FeatureFactory.newCategoricalFeature((String)"x", (String)value);
        Feature y = FeatureFactory.newCategoricalFeature((String)"y", (String)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void TextDistanceSameValue(int seed) {
        String value = UUID.randomUUID().toString();
        Feature x = FeatureFactory.newTextFeature((String)"x", (String)value);
        Feature y = FeatureFactory.newTextFeature((String)"y", (String)value);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.TEXT, (Object)ox.getType());
        Assertions.assertEquals((double)0.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt(1000);
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value + 100));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value - 100));
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void IntegerDistanceDifferentValueThreshold(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt(1000);
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value + 100));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.05);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value - 100));
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.05);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceZero(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)0.0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)1.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)-1.0);
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceDifferentValueThresholdMet(int seed) {
        double value = 100.0;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)100.0);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)80.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.1);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.2);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.3);
        Assertions.assertFalse((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void DoubleDistanceDifferentValueThreshold(int seed) {
        Random random = new Random(seed);
        double value = random.nextDouble() * 100.0;
        Feature x = FeatureFactory.newNumericalFeature((String)"x", (Number)value);
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value + 100.0));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.25);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.NUMBER, (Object)oy.getType());
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
        y = FeatureFactory.newNumericalFeature((String)"y", (Number)(value - 100.0));
        oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.25);
        Assertions.assertTrue((distance * distance > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void BooleanDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        Feature x = FeatureFactory.newBooleanFeature((String)"x", (Boolean)value);
        Feature y = FeatureFactory.newBooleanFeature((String)"y", (Boolean)(!value ? 1 : 0));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void BooleanDistanceDifferentValueThreshold(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        Feature x = FeatureFactory.newBooleanFeature((String)"x", (Boolean)value);
        Feature y = FeatureFactory.newBooleanFeature((String)"y", (Boolean)(!value ? 1 : 0));
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)0.25);
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.BOOLEAN, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void CategoricalDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newCategoricalFeature((String)"x", (String)UUID.randomUUID().toString());
        Feature y = FeatureFactory.newCategoricalFeature((String)"y", (String)UUID.randomUUID().toString());
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.CATEGORICAL, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
        distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy, (double)random.nextDouble());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void TextDistanceDifferentValue(int seed) {
        Random random = new Random(seed);
        Feature x = FeatureFactory.newTextFeature((String)"x", (String)UUID.randomUUID().toString());
        Feature y = FeatureFactory.newTextFeature((String)"y", (String)UUID.randomUUID().toString());
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        double distance = CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy);
        Assertions.assertEquals((Object)Type.TEXT, (Object)ox.getType());
        Assertions.assertEquals((Object)Type.TEXT, (Object)oy.getType());
        Assertions.assertEquals((double)1.0, (double)distance);
    }

    @Test
    void differentFeatureTypes() {
        Feature x = FeatureFactory.newCategoricalFeature((String)"x", (String)UUID.randomUUID().toString());
        Feature y = FeatureFactory.newNumericalFeature((String)"y", (Number)0.0);
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy));
        Assertions.assertEquals((Object)"Features must have the same type. Feature 'x', has type 'categorical' and 'number'", (Object)exception.getMessage());
    }

    @Test
    void unsupportedFeatureType() {
        Feature x = FeatureFactory.newTimeFeature((String)"x", (LocalTime)LocalTime.now());
        Feature y = FeatureFactory.newTimeFeature((String)"y", (LocalTime)LocalTime.now());
        Output ox = CounterfactualScoreCalculatorTest.outputFromFeature(x);
        Output oy = CounterfactualScoreCalculatorTest.outputFromFeature(y);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterFactualScoreCalculator.outputDistance((Output)ox, (Output)oy));
        Assertions.assertEquals((Object)"Feature 'x' has unsupported type 'time'", (Object)exception.getMessage());
    }

    @Test
    void testGoalSizeMatch() throws ExecutionException, InterruptedException {
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", (Number)2.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input, (PredictionFeatureDomain)domains, constraints, null);
        ArrayList<Output> goal = new ArrayList<Output>();
        goal.add(new Output("f-2", Type.NUMBER, new Value((Object)2.0), 0.0));
        goal.add(new Output("f-3", Type.BOOLEAN, new Value((Object)true), 0.0));
        CounterfactualSolution solution = new CounterfactualSolution(entities, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        BendableBigDecimalScore score = scoreCalculator.calculateScore(solution);
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertTrue((boolean)score.isFeasible());
        Assertions.assertEquals((int)2, (int)goal.size());
        Assertions.assertEquals((int)1, (int)predictionOutputs.size());
        Assertions.assertEquals((int)2, (int)((PredictionOutput)predictionOutputs.get(0)).getOutputs().size());
        Assertions.assertEquals((int)0, (int)score.getHardScore(0).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getHardScore(1).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getHardScore(2).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getSoftScore(0).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)0, (int)score.getSoftScore(1).compareTo(BigDecimal.ZERO));
        Assertions.assertEquals((int)3, (int)score.getHardLevelsSize());
        Assertions.assertEquals((int)2, (int)score.getSoftLevelsSize());
    }

    @Test
    void testGoalSizeSmaller() throws ExecutionException, InterruptedException {
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", (Number)2.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input, (PredictionFeatureDomain)domains, constraints, null);
        ArrayList<Output> goal = new ArrayList<Output>();
        goal.add(new Output("f-2", Type.NUMBER, new Value((Object)2.0), 0.0));
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertEquals((int)1, (int)goal.size());
        Assertions.assertEquals((int)1, (int)predictionOutputs.size());
        Assertions.assertEquals((int)2, (int)((PredictionOutput)predictionOutputs.get(0)).getOutputs().size());
        CounterfactualSolution solution = new CounterfactualSolution(entities, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> scoreCalculator.calculateScore(solution));
        Assertions.assertEquals((Object)"Prediction size must be equal to goal size", (Object)exception.getMessage());
    }

    @Test
    void testGoalSizeLarger() throws ExecutionException, InterruptedException {
        CounterFactualScoreCalculator scoreCalculator = new CounterFactualScoreCalculator();
        PredictionProvider model = TestUtils.getFeatureSkipModel(0);
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureDomain> featureDomains = new ArrayList<FeatureDomain>();
        ArrayList<Boolean> constraints = new ArrayList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-1", (Number)1.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newNumericalFeature((String)"f-2", (Number)2.0));
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)10.0));
        constraints.add(false);
        features.add(FeatureFactory.newBooleanFeature((String)"f-3", (Boolean)true));
        featureDomains.add(EmptyFeatureDomain.create());
        constraints.add(false);
        PredictionInput input = new PredictionInput(features);
        PredictionFeatureDomain domains = new PredictionFeatureDomain(featureDomains);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input, (PredictionFeatureDomain)domains, constraints, null);
        ArrayList<Output> goal = new ArrayList<Output>();
        goal.add(new Output("f-1", Type.NUMBER, new Value((Object)1.0), 0.0));
        goal.add(new Output("f-2", Type.NUMBER, new Value((Object)2.0), 0.0));
        goal.add(new Output("f-3", Type.BOOLEAN, new Value((Object)true), 0.0));
        List predictionOutputs = (List)model.predictAsync(List.of(input)).get();
        Assertions.assertEquals((int)3, (int)goal.size());
        Assertions.assertEquals((int)1, (int)predictionOutputs.size());
        Assertions.assertEquals((int)2, (int)((PredictionOutput)predictionOutputs.get(0)).getOutputs().size());
        CounterfactualSolution solution = new CounterfactualSolution(entities, model, goal, UUID.randomUUID(), UUID.randomUUID(), 0.0);
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> scoreCalculator.calculateScore(solution));
        Assertions.assertEquals((Object)"Prediction size must be equal to goal size", (Object)exception.getMessage());
    }
}

