/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedIntegerEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;

class SimilarityTest {
    private static double HIGHEST_SIMILARITY = 1.0;
    private static double LOWEST_SIMILARITY = 0.0;

    SimilarityTest() {
    }

    @Test
    void integerSimpleSimilarity() {
        int value = 20;
        IntegerEntity x = IntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)20), (int)0, (int)100);
        x.setProposedValue(Integer.valueOf(29));
        double similarity1 = x.similarity();
        x.setProposedValue(Integer.valueOf(11));
        double similarity2 = x.similarity();
        Assertions.assertEquals((double)similarity1, (double)similarity2);
        Assertions.assertTrue((similarity1 > 0.9 ? 1 : 0) != 0);
    }

    @Test
    void doubleSimpleSimilarity() {
        double value = 500.0;
        DoubleEntity x = DoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)500.0), (double)0.0, (double)1000.0);
        x.setProposedValue(Double.valueOf(590.0));
        double similarity1 = x.similarity();
        x.setProposedValue(Double.valueOf(410.0));
        double similarity2 = x.similarity();
        Assertions.assertEquals((double)similarity1, (double)similarity2);
        Assertions.assertTrue((similarity1 > 0.9 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void booleanSimpleSimilarity(int seed) {
        Random random = new Random(seed);
        boolean originalValue = random.nextBoolean();
        BooleanEntity x = BooleanEntity.from((Feature)FeatureFactory.newBooleanFeature((String)"x", (Boolean)originalValue));
        x.setProposedValue(Boolean.valueOf(!originalValue));
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        x.setProposedValue(Boolean.valueOf(originalValue));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @Test
    void categoricalSimpleSimilarity() {
        String value = "foo";
        Set<String> categories = Set.of("foo", "bar", "baz");
        CategoricalEntity x = CategoricalEntity.from((Feature)FeatureFactory.newCategoricalFeature((String)"x", (String)"foo"), categories);
        x.setProposedValue("bar");
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        x.setProposedValue("baz");
        Assertions.assertEquals((double)LOWEST_SIMILARITY, (double)x.similarity());
        x.setProposedValue("foo");
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedIntegerSimilarity(int seed) {
        Random random = new Random(seed);
        int value = random.nextInt();
        FixedIntegerEntity x = FixedIntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedDoubleSimilarity(int seed) {
        Random random = new Random(seed);
        double value = random.nextDouble();
        FixedDoubleEntity x = FixedDoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void fixedBooleanSimilarity(int seed) {
        Random random = new Random(seed);
        boolean value = random.nextBoolean();
        FixedBooleanEntity x = FixedBooleanEntity.from((Feature)FeatureFactory.newBooleanFeature((String)"x", (Boolean)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @RepeatedTest(value=5)
    void fixedCategoricalSimilarity() {
        String value = UUID.randomUUID().toString();
        FixedCategoricalEntity x = FixedCategoricalEntity.from((Feature)FeatureFactory.newCategoricalFeature((String)"x", (String)value));
        Assertions.assertEquals((double)HIGHEST_SIMILARITY, (double)x.similarity());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void constantRelativeSimilarityIntegerEntity(int seed) {
        int[] values;
        Random random = new Random(seed);
        int MAX_UPPER_BOUND_RANGE = 10000;
        values = new int[]{random.nextInt(1000), values[0] + random.nextInt(100), values[1] + random.nextInt(100)};
        int lowerBound = random.nextInt(values[0] - 1);
        int upperBound = values[2] + random.nextInt(10000) + 1;
        IntegerEntity x = IntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)values[0]), (int)lowerBound, (int)upperBound);
        x.setProposedValue(Integer.valueOf(values[1]));
        double x_similarity1 = x.similarity();
        x.setProposedValue(Integer.valueOf(values[2]));
        double x_similarity2 = x.similarity();
        lowerBound = random.nextInt(values[0] - 1);
        upperBound = values[2] + random.nextInt(10000) + 1;
        IntegerEntity y = IntegerEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"y", (Number)values[0]), (int)lowerBound, (int)upperBound);
        y.setProposedValue(Integer.valueOf(values[1]));
        double y_similarity1 = y.similarity();
        y.setProposedValue(Integer.valueOf(values[2]));
        double y_similarity2 = y.similarity();
        Assertions.assertTrue((x_similarity1 > x_similarity2 ? 1 : 0) != 0);
        Assertions.assertTrue((y_similarity1 > y_similarity2 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void constantRelativeSimilarityDoubleEntity(int seed) {
        double[] values;
        Random random = new Random(seed);
        double MAX_UPPER_BOUND_RANGE = 10000.0;
        values = new double[]{random.nextDouble() * 1000.0, values[0] + random.nextDouble() * 100.0, values[1] + random.nextDouble() * 100.0};
        double lowerBound = random.nextDouble() * values[0];
        double upperBound = values[2] + random.nextDouble() * 10000.0;
        DoubleEntity x = DoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"x", (Number)values[0]), (double)lowerBound, (double)upperBound);
        x.setProposedValue(Double.valueOf(values[1]));
        double x_similarity1 = x.similarity();
        x.setProposedValue(Double.valueOf(values[2]));
        double x_similarity2 = x.similarity();
        lowerBound = random.nextDouble() * values[0];
        upperBound = values[2] + random.nextDouble() * 10000.0;
        DoubleEntity y = DoubleEntity.from((Feature)FeatureFactory.newNumericalFeature((String)"y", (Number)values[0]), (double)lowerBound, (double)upperBound);
        y.setProposedValue(Double.valueOf(values[1]));
        double y_similarity1 = y.similarity();
        y.setProposedValue(Double.valueOf(values[2]));
        double y_similarity2 = y.similarity();
        Assertions.assertTrue((x_similarity1 > x_similarity2 ? 1 : 0) != 0);
        Assertions.assertTrue((y_similarity1 > y_similarity2 ? 1 : 0) != 0);
    }
}

