/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.kogito.explainability.local.counterfactual.entities.AbstractEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedIntegerEntity;
import org.kie.kogito.explainability.model.DataDistribution;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.PredictionFeatureDomain;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.domain.FeatureDomain;

public class CounterfactualEntityFactory {
    private CounterfactualEntityFactory() {
    }

    public static CounterfactualEntity from(Feature feature, Boolean isConstrained, FeatureDomain featureDomain) {
        return CounterfactualEntityFactory.from(feature, isConstrained, featureDomain, null);
    }

    public static CounterfactualEntity from(Feature feature, Boolean isConstrained, FeatureDomain featureDomain, FeatureDistribution featureDistribution) {
        AbstractEntity entity = null;
        if (feature.getType() == Type.NUMBER) {
            if (feature.getValue().getUnderlyingObject() instanceof Double) {
                entity = isConstrained.booleanValue() ? FixedDoubleEntity.from(feature) : DoubleEntity.from(feature, featureDomain.getLowerBound(), featureDomain.getUpperBound(), featureDistribution, isConstrained);
            } else if (feature.getValue().getUnderlyingObject() instanceof Integer) {
                entity = isConstrained.booleanValue() ? FixedIntegerEntity.from(feature) : IntegerEntity.from(feature, featureDomain.getLowerBound().intValue(), featureDomain.getUpperBound().intValue(), featureDistribution, isConstrained);
            }
        } else if (feature.getType() == Type.BOOLEAN) {
            entity = isConstrained.booleanValue() ? FixedBooleanEntity.from(feature) : BooleanEntity.from(feature, isConstrained);
        } else if (feature.getType() == Type.CATEGORICAL) {
            entity = isConstrained.booleanValue() ? FixedCategoricalEntity.from(feature) : CategoricalEntity.from(feature, featureDomain.getCategories(), isConstrained);
        } else {
            throw new IllegalArgumentException("Unsupported feature type: " + feature.getType());
        }
        return entity;
    }

    public static List<CounterfactualEntity> createEntities(PredictionInput predictionInput, PredictionFeatureDomain featureDomain, List<Boolean> constraints, DataDistribution dataDistribution) {
        List<FeatureDomain> domains = featureDomain.getFeatureDomains();
        return IntStream.range(0, predictionInput.getFeatures().size()).mapToObj(featureIndex -> {
            Feature feature = predictionInput.getFeatures().get(featureIndex);
            Boolean isConstrained = (Boolean)constraints.get(featureIndex);
            FeatureDomain domain = (FeatureDomain)domains.get(featureIndex);
            FeatureDistribution featureDistribution = Optional.ofNullable(dataDistribution).map(dd -> dd.asFeatureDistributions().get(featureIndex)).orElse(null);
            return CounterfactualEntityFactory.from(feature, isConstrained, domain, featureDistribution);
        }).collect(Collectors.toList());
    }
}

