/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.utils.WeightedLinearRegression;
import org.kie.kogito.explainability.utils.WeightedLinearRegressionResults;

class WeightedLinearRegressionTest {
    static Random random = new Random();

    WeightedLinearRegressionTest() {
    }

    @BeforeAll
    static void initRandom() {
        random.setSeed(0L);
    }

    @Test
    void testOverspecifiedNoIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}, {-20.0, 15.0, 3.3, 1.0}, {0.0, 3.0, -1.0, 2.2}, {17.0, -3.0, 0.0, 7.0}};
        double[] y = new double[]{104.0, 88.2, 130.0, 102.4, 35.2, 80.0};
        double[] sampleWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.3, 0.3};
        double[] actualCoefs = new double[]{4.0, 10.0, 8.0, 6.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)false, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
    }

    @Test
    void testOverspecifiedIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}, {-20.0, 15.0, 3.3, 1.0}, {0.0, 3.0, -1.0, 2.2}, {17.0, -3.0, 0.0, 7.0}};
        double[] y = new double[]{109.0, 93.2, 135.0, 107.4, 40.2, 85.0};
        double[] sampleWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.3, 0.3};
        double[] actualCoefs = new double[]{4.0, 10.0, 8.0, 6.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0E-6);
        Assertions.assertEquals((double)5.0, (double)wlrr.getIntercept(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
    }

    @Test
    void testOverspecifiedWithError() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0}, {10.0, 5.0, -3.0}, {14.0, -6.6, 7.0}, {-20.0, 15.0, 3.3}, {0.0, 3.0, -1.0}, {17.0, -3.0, 0.0}};
        double[] y = new double[]{131.24777803, 72.68862812, 51.48328659, 105.24910402, 23.76140738, 41.08339528};
        double[] sampleWeights = new double[]{0.11155536, 0.2297424, 0.18834107, 0.30395088, 0.06050119, 0.10590911};
        double[] actualCoefs = new double[]{4.0, 10.0, 8.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0);
        Assertions.assertTrue((wlrr.getMSE() <= 10.0 ? 1 : 0) != 0);
    }

    @Test
    void testUnderspecifiedNoIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{104.0, 88.2, 130.0};
        double[] sampleWeights = new double[]{0.8, 0.1, 0.1};
        for (int run = 0; run < 100; ++run) {
            WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)false, (Random)random);
            Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
        }
    }

    @Test
    void testUnderspecifiedIntercept() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{103.0, 87.2, 129.0};
        double[] sampleWeights = new double[]{0.8, 0.1, 0.1};
        for (int run = 0; run < 100; ++run) {
            WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random);
            Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
        }
    }

    @Test
    void testStdErr() {
        for (int test = 0; test < 1; ++test) {
            double[] trueCoefs = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
            double[] expectedErr = new double[]{0.519, 0.537, 0.586, 0.415, 0.391};
            double[] expectedP = new double[]{0.037, 0.415, 0.001, 0.0, 0.0};
            double[][] x = new double[][]{{8.32, 7.9, 0.31, 3.85, 0.05}, {2.39, 7.59, 4.06, 8.73, 8.59}, {1.59, 1.1, 4.3, 9.49, 2.13}, {5.36, 2.64, 4.65, 9.88, 5.25}, {1.96, 2.44, 0.58, 4.24, 0.3}, {8.22, 8.07, 0.57, 2.34, 8.89}, {9.08, 0.56, 2.22, 9.81, 0.34}, {4.84, 6.52, 3.12, 8.62, 9.79}, {2.42, 8.5, 9.33, 3.96, 9.9}, {5.1, 9.88, 8.6, 7.58, 3.0}};
            double[] y = new double[]{33.26402211568451, 107.47389791796185, 72.15586479806592, 96.52857945629758, 29.289064802655997, 78.73842411657569, 68.1835699678292, 122.79428874425378, 119.66821422153396, 96.08485899842191};
            double[] sampleWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)false, (Random)random);
            double[] coefs = wlrr.getCoefficients();
            double[] conf = wlrr.getConf(0.01);
            double[] ub = IntStream.range(0, coefs.length).mapToDouble(i -> coefs[i] + conf[i]).toArray();
            double[] lb = IntStream.range(0, coefs.length).mapToDouble(i -> coefs[i] - conf[i]).toArray();
            Assertions.assertArrayEquals((double[])expectedErr, (double[])wlrr.getStdErrors(), (double)0.01);
            Assertions.assertArrayEquals((double[])expectedP, (double[])wlrr.getPValues(), (double)0.01);
        }
    }

    @Test
    void testOneSample() {
        double[][] x = new double[][]{{1.0, 2.0, 3.0, 4.0}};
        double[] y = new double[]{72.0};
        double[] sampleWeights = new double[]{1.0};
        Assertions.assertThrows(ArithmeticException.class, () -> WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random));
    }

    @Test
    void testOneFeature() {
        double[][] x = new double[][]{{1.0}, {4.0}, {10.0}, {5.0}};
        double[] y = new double[]{5.0, 20.0, 50.0, 25.0};
        double[] sampleWeights = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] actualCoefs = new double[]{5.0};
        WeightedLinearRegressionResults wlrr = WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)false, (Random)random);
        Assertions.assertArrayEquals((double[])actualCoefs, (double[])wlrr.getCoefficients(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getIntercept(), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)wlrr.getMSE(), (double)1.0E-6);
    }

    @Test
    void testSampleMismatch() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{103.0, 87.2};
        double[] sampleWeights = new double[]{0.8, 0.1, 0.1};
        Assertions.assertThrows(IllegalArgumentException.class, () -> WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random));
    }

    @Test
    void testZeroWeights() {
        double[][] x = new double[][]{{1.0, 10.0, 3.0, -4.0}, {10.0, 5.0, -3.0, 3.7}, {14.0, -6.6, 7.0, 14.0}};
        double[] y = new double[]{103.0, 87.2};
        double[] sampleWeights = new double[]{0.0, 0.0, 0.0};
        Assertions.assertThrows(IllegalArgumentException.class, () -> WeightedLinearRegression.fit((double[][])x, (double[])y, (double[])sampleWeights, (boolean)true, (Random)random));
    }
}

