/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import org.kie.kogito.explainability.local.counterfactual.entities.AbstractEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.utils.DataUtils;

public abstract class AbstractNumericEntity<T extends Number>
extends AbstractEntity<T> {
    protected T rangeMinimum;
    protected T rangeMaximum;
    protected Double stdDev;
    protected Double range;

    protected AbstractNumericEntity() {
    }

    protected AbstractNumericEntity(T originalValue, String featureName, T minimum, T maximum, FeatureDistribution featureDistribution, boolean constrained) {
        super(originalValue, featureName, constrained);
        this.rangeMinimum = minimum;
        this.rangeMaximum = maximum;
        this.range = ((Number)maximum).doubleValue() - ((Number)minimum).doubleValue();
        if (featureDistribution != null) {
            double[] samples = featureDistribution.getAllSamples().stream().mapToDouble(Value::asNumber).toArray();
            double mean = DataUtils.getMean(samples);
            this.stdDev = DataUtils.getStdDev(samples, mean);
        }
    }

    @Override
    public String toString() {
        return ((Number)this.originalValue).getClass().getName() + "Entity{value=" + this.proposedValue + ", rangeMinimum=" + this.rangeMinimum + ", rangeMaximum=" + this.rangeMaximum + ", id='" + this.featureName + "'}";
    }

    @Override
    public double distance() {
        double distance = Math.abs(((Number)this.proposedValue).doubleValue() - ((Number)this.originalValue).doubleValue());
        if (this.stdDev != null) {
            return distance / (this.stdDev * this.stdDev);
        }
        return distance;
    }

    @Override
    public double similarity() {
        return 1.0 - Math.abs(((Number)this.proposedValue).doubleValue() - ((Number)this.originalValue).doubleValue()) / this.range;
    }

    @Override
    public Feature asFeature() {
        return FeatureFactory.newNumericalFeature(this.featureName, (Number)this.proposedValue);
    }
}

