/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.local.counterfactual.entities.BooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedBooleanEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedCategoricalEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedDoubleEntity;
import org.kie.kogito.explainability.local.counterfactual.entities.fixed.FixedIntegerEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PredictionFeatureDomain;
import org.kie.kogito.explainability.model.PredictionInput;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.EmptyFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;

class CounterfactualEntityFactoryTest {
    CounterfactualEntityFactoryTest() {
    }

    @Test
    void testIntegerFactory() {
        int value = 5;
        Feature feature = FeatureFactory.newNumericalFeature((String)"int-feature", (Number)5);
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof IntegerEntity));
        Assertions.assertEquals((double)5.0, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testFixedIntegerFactory() {
        int value = 5;
        Feature feature = FeatureFactory.newNumericalFeature((String)"int-feature", (Number)5);
        FeatureDomain domain = EmptyFeatureDomain.create();
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedIntegerEntity));
        Assertions.assertEquals((double)5.0, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testDoubleFactory() {
        double value = 5.5;
        Feature feature = FeatureFactory.newNumericalFeature((String)"double-feature", (Number)5.5);
        FeatureDomain domain = NumericalFeatureDomain.create((double)0.0, (double)10.0);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof DoubleEntity));
        Assertions.assertEquals((double)5.5, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testFixedDoubleFactory() {
        double value = 5.5;
        Feature feature = FeatureFactory.newNumericalFeature((String)"double-feature", (Number)5.5);
        FeatureDomain domain = EmptyFeatureDomain.create();
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedDoubleEntity));
        Assertions.assertEquals((double)5.5, (double)counterfactualEntity.asFeature().getValue().asNumber());
    }

    @Test
    void testBooleanFactory() {
        boolean value = false;
        Feature feature = FeatureFactory.newBooleanFeature((String)"bool-feature", (Boolean)false);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)EmptyFeatureDomain.create());
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof BooleanEntity));
        Assertions.assertEquals((Object)false, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testFixedBooleanFactory() {
        boolean value = false;
        Feature feature = FeatureFactory.newBooleanFeature((String)"bool-feature", (Boolean)false);
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)EmptyFeatureDomain.create());
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedBooleanEntity));
        Assertions.assertEquals((Object)false, (Object)counterfactualEntity.asFeature().getValue().getUnderlyingObject());
    }

    @Test
    void testCategoricalFactoryObject() {
        String value = "foo";
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        FeatureDomain domain = CategoricalFeatureDomain.create((String[])new String[]{"foo", "bar"});
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testFixedCategoricalEntity() {
        String value = "foo";
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        FeatureDomain domain = EmptyFeatureDomain.create();
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof FixedCategoricalEntity));
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testCategoricalFactorySet() {
        String value = "foo";
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        FeatureDomain domain = CategoricalFeatureDomain.create(Set.of("foo", "bar"));
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testCategoricalFactoryList() {
        String value = "foo";
        Feature feature = FeatureFactory.newCategoricalFeature((String)"categorical-feature", (String)"foo");
        FeatureDomain domain = CategoricalFeatureDomain.create(List.of("foo", "bar"));
        CounterfactualEntity counterfactualEntity = CounterfactualEntityFactory.from((Feature)feature, (Boolean)false, (FeatureDomain)domain);
        Assertions.assertTrue((boolean)(counterfactualEntity instanceof CategoricalEntity));
        Assertions.assertEquals((Object)domain.getCategories(), (Object)((CategoricalEntity)counterfactualEntity).getValueRange());
        Assertions.assertEquals((Object)"foo", (Object)counterfactualEntity.asFeature().getValue().toString());
    }

    @Test
    void testCreateFixedEntities() {
        LinkedList<Feature> features = new LinkedList<Feature>();
        LinkedList<FeatureDomain> featureDomains = new LinkedList<FeatureDomain>();
        LinkedList<Boolean> constraints = new LinkedList<Boolean>();
        features.add(FeatureFactory.newNumericalFeature((String)"f-num1", (Number)100.1));
        constraints.add(true);
        featureDomains.add(EmptyFeatureDomain.create());
        features.add(FeatureFactory.newNumericalFeature((String)"f-num2", (Number)100.2));
        constraints.add(false);
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)1000.0));
        features.add(FeatureFactory.newNumericalFeature((String)"f-num3", (Number)100.3));
        constraints.add(true);
        featureDomains.add(EmptyFeatureDomain.create());
        features.add(FeatureFactory.newNumericalFeature((String)"f-num4", (Number)100.4));
        constraints.add(false);
        featureDomains.add(NumericalFeatureDomain.create((double)0.0, (double)1000.0));
        PredictionFeatureDomain featureDomain = new PredictionFeatureDomain(featureDomains);
        PredictionInput input = new PredictionInput(features);
        List entities = CounterfactualEntityFactory.createEntities((PredictionInput)input, (PredictionFeatureDomain)featureDomain, constraints, null);
        Assertions.assertTrue((boolean)(entities.get(0) instanceof FixedDoubleEntity));
        Assertions.assertTrue((boolean)(entities.get(1) instanceof DoubleEntity));
        Assertions.assertTrue((boolean)(entities.get(2) instanceof FixedDoubleEntity));
        Assertions.assertTrue((boolean)(entities.get(3) instanceof DoubleEntity));
        Assertions.assertEquals((double)100.1, (double)((CounterfactualEntity)entities.get(0)).asFeature().getValue().asNumber());
        Assertions.assertEquals((double)100.2, (double)((CounterfactualEntity)entities.get(1)).asFeature().getValue().asNumber());
        Assertions.assertEquals((double)100.3, (double)((CounterfactualEntity)entities.get(2)).asFeature().getValue().asNumber());
        Assertions.assertEquals((double)100.4, (double)((CounterfactualEntity)entities.get(3)).asFeature().getValue().asNumber());
        Assertions.assertTrue((boolean)((CounterfactualEntity)entities.get(0)).isConstrained());
        Assertions.assertFalse((boolean)((CounterfactualEntity)entities.get(1)).isConstrained());
        Assertions.assertTrue((boolean)((CounterfactualEntity)entities.get(2)).isConstrained());
        Assertions.assertFalse((boolean)((CounterfactualEntity)entities.get(3)).isConstrained());
    }

    @Test
    void testValidateNullNumericalFeature() {
        Feature feature = FeatureFactory.newNumericalFeature((String)"double-feature", null);
        FeatureDomain domain = EmptyFeatureDomain.create();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CounterfactualEntityFactory.from((Feature)feature, (Boolean)true, (FeatureDomain)domain));
        Assertions.assertEquals((Object)"Null numeric features are not supported in counterfactuals", (Object)exception.getMessage());
    }
}

