/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.lime;

import java.util.ArrayList;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.local.lime.ProximityFilter;

class ProximityFilterTest {
    ProximityFilterTest() {
    }

    @Test
    void testFilter() {
        ProximityFilter filter = new ProximityFilter(0.5, 0.1);
        int size = 10;
        ArrayList<Pair<double[], Double>> trainingSet = new ArrayList<Pair<double[], Double>>();
        double[] weights = new double[size];
        TestUtils.fillBalancedDataForFiltering(size, trainingSet, weights);
        filter.apply(trainingSet, weights);
        AssertionsForClassTypes.assertThat((int)trainingSet.size()).isEqualTo(5);
    }

    @Test
    void testNoFilterWithNonMatchingSizes() {
        ProximityFilter filter = new ProximityFilter(0.5, 0.1);
        int size = 10;
        ArrayList<Pair<double[], Double>> trainingSet = new ArrayList<Pair<double[], Double>>();
        double[] weights = new double[size];
        TestUtils.fillBalancedDataForFiltering(size, trainingSet, weights);
        trainingSet.remove(0);
        filter.apply(trainingSet, weights);
        AssertionsForClassTypes.assertThat((int)trainingSet.size()).isEqualTo(9);
    }

    @Test
    void testFilterNull() {
        ProximityFilter filter = new ProximityFilter(0.5, 0.1);
        AssertionsForClassTypes.assertThatCode(() -> filter.apply(null, null)).doesNotThrowAnyException();
    }
}

