/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.utils.WeightedLinearRegressionResults;

class WeightedLinearRegressionResultsTest {
    WeightedLinearRegressionResultsTest() {
    }

    @Test
    void testWLRResultsNoIntercept() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}};
        double[] flatCoef = new double[]{5.0, 1.0, -1.0, 3.0};
        double[] stdErrs = new double[]{5.0, 1.0, -1.0, 3.0};
        double[] pvalues = new double[4];
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, false, 1, 0.01, stdErrs, pvalues);
        Assertions.assertArrayEquals((double[])flatCoef, (double[])wlrr.getCoefficients());
        Assertions.assertArrayEquals((double[])stdErrs, (double[])wlrr.getStdErrors());
        Assertions.assertArrayEquals((double[])pvalues, (double[])wlrr.getPValues());
        Assertions.assertEquals((double)0.0, (double)wlrr.getIntercept());
        Assertions.assertEquals((double)0.01, (double)wlrr.getMSE());
    }

    @Test
    void testWLRResultWithIntercept() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}};
        double[] flatCoef = new double[]{5.0, 1.0, -1.0};
        double[] stdErrs = new double[]{5.0, 1.0, -1.0, 3.0};
        double[] pvalues = new double[4];
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, true, 1, 0.01, stdErrs, pvalues);
        Assertions.assertArrayEquals((double[])flatCoef, (double[])wlrr.getCoefficients());
        Assertions.assertArrayEquals((double[])stdErrs, (double[])wlrr.getStdErrors());
        Assertions.assertEquals((double)3.0, (double)wlrr.getIntercept());
        Assertions.assertEquals((double)0.01, (double)wlrr.getMSE());
    }

    @Test
    void testPredictions() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}, {5.0}};
        double[] stdErrs = new double[]{5.0, 1.0, -1.0, 3.0, 5.0};
        double[][] x = new double[][]{{1.0, 5.0, 3.0, -2.0}, {10.0, -1.0, 0.0, 4.0}, {-2.0, 7.5, 6.0, -3.3}};
        double[] pvalues = new double[5];
        double[] y = new double[]{6.0, 66.0, -13.4};
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, true, 1, 0.01, stdErrs, pvalues);
        Assertions.assertArrayEquals((double[])y, (double[])wlrr.predict((double[][])x), (double)1.0E-6);
    }

    @Test
    void testPredictionsWrongNumFeatures() {
        double[][] coefficients = new double[][]{{5.0}, {1.0}, {-1.0}, {3.0}, {5.0}};
        double[] stdErrs = new double[]{5.0, 1.0, -1.0, 3.0, 5.0};
        double[] pvalues = new double[5];
        double[][] x = new double[][]{{1.0, 5.0}, {10.0, -1.0}, {-2.0, 7.5}};
        WeightedLinearRegressionResults wlrr = new WeightedLinearRegressionResults((double[][])coefficients, true, 1, 0.01, stdErrs, pvalues);
        Assertions.assertThrows(IllegalArgumentException.class, () -> wlrr.predict(x));
    }
}

