/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import org.kie.kogito.explainability.local.counterfactual.entities.AbstractNumericEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeFactory;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;

@PlanningEntity
public class IntegerEntity
extends AbstractNumericEntity<Integer> {
    public IntegerEntity() {
    }

    private IntegerEntity(Integer originalValue, String featureName, int minimum, int maximum, FeatureDistribution featureDistribution, boolean constrained) {
        super(originalValue, featureName, minimum, maximum, featureDistribution, constrained);
    }

    public static IntegerEntity from(Feature originalFeature, int minimum, int maximum, boolean constrained) {
        return IntegerEntity.from(originalFeature, minimum, maximum, null, constrained);
    }

    public static IntegerEntity from(Feature originalFeature, int minimum, int maximum, FeatureDistribution featureDistribution, boolean constrained) {
        return new IntegerEntity((int)originalFeature.getValue().asNumber(), originalFeature.getName(), minimum, maximum, featureDistribution, constrained);
    }

    public static IntegerEntity from(Feature feature, int minimum, int maximum) {
        return IntegerEntity.from(feature, minimum, maximum, null, false);
    }

    public static IntegerEntity from(Feature feature, int minimum, int maximum, FeatureDistribution featureDistribution) {
        return IntegerEntity.from(feature, minimum, maximum, featureDistribution, false);
    }

    @ValueRangeProvider(id="intRange")
    public ValueRange<Integer> getValueRange() {
        return ValueRangeFactory.createIntValueRange((int)((Integer)this.rangeMinimum), (int)((Integer)this.rangeMaximum));
    }

    @PlanningVariable(valueRangeProviderRefs={"intRange"})
    public Integer getProposedValue() {
        return (Integer)this.proposedValue;
    }

    public void setProposedValue(Integer proposedValue) {
        this.proposedValue = proposedValue;
    }
}

