/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.local.counterfactual.entities.DoubleEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.NumericFeatureDistribution;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;

class DoubleEntityTest {
    DoubleEntityTest() {
    }

    @Test
    void distanceUnscaled() {
        Feature doubleFeature = FeatureFactory.newNumericalFeature((String)"feature-double", (Number)20.0);
        FeatureDomain featureDomain = NumericalFeatureDomain.create((double)0.0, (double)40.0);
        DoubleEntity entity = (DoubleEntity)CounterfactualEntityFactory.from((Feature)doubleFeature, (Boolean)false, (FeatureDomain)featureDomain);
        entity.proposedValue = 30.0;
        Assertions.assertEquals((double)10.0, (double)entity.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void distanceScaled(int seed) {
        Random random = new Random();
        random.setSeed(seed);
        Feature doubleFeature = FeatureFactory.newNumericalFeature((String)"feature-double", (Number)20.0);
        FeatureDomain featureDomain = NumericalFeatureDomain.create((double)0.0, (double)40.0);
        NumericFeatureDistribution featureDistribution = new NumericFeatureDistribution(doubleFeature, random.doubles(5000L, 10.0, 40.0).toArray());
        DoubleEntity entity = (DoubleEntity)CounterfactualEntityFactory.from((Feature)doubleFeature, (Boolean)false, (FeatureDomain)featureDomain, (FeatureDistribution)featureDistribution);
        entity.proposedValue = 30.0;
        double distance = entity.distance();
        Assertions.assertTrue((distance > 0.1 && distance < 0.2 ? 1 : 0) != 0);
    }
}

