/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.counterfactual.entities;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.explainability.local.counterfactual.entities.CounterfactualEntityFactory;
import org.kie.kogito.explainability.local.counterfactual.entities.IntegerEntity;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureDistribution;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.NumericFeatureDistribution;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;

class IntegerEntityTest {
    IntegerEntityTest() {
    }

    @Test
    void distanceUnscaled() {
        Feature integerFeature = FeatureFactory.newNumericalFeature((String)"feature-integer", (Number)20);
        FeatureDomain featureDomain = NumericalFeatureDomain.create((double)0.0, (double)100.0);
        IntegerEntity entity = (IntegerEntity)CounterfactualEntityFactory.from((Feature)integerFeature, (Boolean)false, (FeatureDomain)featureDomain);
        entity.proposedValue = 40;
        Assertions.assertEquals((double)20.0, (double)entity.distance());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 4})
    void distanceScaled(int seed) {
        Random random = new Random();
        random.setSeed(seed);
        Feature integerFeature = FeatureFactory.newNumericalFeature((String)"feature-integer", (Number)20);
        FeatureDomain featureDomain = NumericalFeatureDomain.create((double)0.0, (double)100.0);
        NumericFeatureDistribution featureDistribution = new NumericFeatureDistribution(integerFeature, random.ints(5000L, 10, 40).mapToDouble(x -> x).toArray());
        IntegerEntity entity = (IntegerEntity)CounterfactualEntityFactory.from((Feature)integerFeature, (Boolean)false, (FeatureDomain)featureDomain, (FeatureDistribution)featureDistribution);
        entity.proposedValue = 40;
        double distance = entity.distance();
        Assertions.assertTrue((distance > 0.2 && distance < 0.3 ? 1 : 0) != 0);
    }
}

